/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.popcraft.chunky.nbt.Tag;

public class LongArrayTag
extends Tag {
    private long[] value;

    protected LongArrayTag(String name) {
        super(name);
    }

    public LongArrayTag(String name, long[] value) {
        super(name);
        this.value = value;
    }

    @Override
    public void read(DataInput input) throws IOException {
        int size = input.readInt();
        this.value = new long[size];
        for (int i = 0; i < size; ++i) {
            this.value[i] = input.readLong();
        }
    }

    @Override
    public void skip(DataInput input) throws IOException {
        int size = input.readInt();
        input.skipBytes(8 * size);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        int size = this.value.length;
        output.writeLong(size);
        for (long i : this.value) {
            output.writeLong(i);
        }
    }

    @Override
    public Tag search(DataInput input, byte type, String name) throws IOException {
        this.skip(input);
        return null;
    }

    @Override
    public byte type() {
        return 12;
    }

    @Override
    public String typeName() {
        return "TAG_Long_Array";
    }

    @Override
    public String print(int level) {
        return "%s%s('%s'): %s".formatted(" ".repeat(level * 2), this.typeName(), this.name, Arrays.toString(this.value));
    }

    public long[] value() {
        return this.value;
    }

    public void value(long[] value) {
        this.value = value;
    }
}

