/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;

public class EntityTicker {
    private static final List<ILootrCart> entities = new ArrayList<ILootrCart>();
    private static final List<ILootrCart> pendingEntities = new ArrayList<ILootrCart>();
    private static final Object listLock = new Object();
    private static final Object levelLock = new Object();
    private static boolean tickingList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerTick() {
        ArrayList<ILootrCart> copy;
        if (LootrAPI.isDisabled()) {
            return;
        }
        ArrayList<ILootrCart> completed = new ArrayList<ILootrCart>();
        Object object = listLock;
        synchronized (object) {
            tickingList = true;
            copy = new ArrayList<ILootrCart>(entities);
            tickingList = false;
        }
        object = levelLock;
        synchronized (object) {
            for (ILootrCart cart : copy) {
                VehicleEntity entity = cart.asEntity();
                ServerLevel world = (ServerLevel)entity.level();
                ServerChunkCache provider = world.getChunkSource();
                if (!provider.hasChunk(Mth.floor((double)(entity.getX() / 16.0)), Mth.floor((double)(entity.getZ() / 16.0)))) continue;
                world.addFreshEntity((Entity)entity);
                completed.add(cart);
            }
        }
        object = listLock;
        synchronized (object) {
            tickingList = true;
            entities.removeAll(completed);
            entities.addAll(pendingEntities);
            tickingList = false;
            pendingEntities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntity(ILootrCart entity) {
        if (LootrAPI.isDisabled()) {
            return;
        }
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntities.add(entity);
            } else {
                entities.add(entity);
            }
        }
    }
}

