/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.processor;

import com.bawnorton.configurable.Configurable;
import com.bawnorton.configurable.processor.ConfigurableSettings;
import com.bawnorton.configurable.processor.entry.ConfigurableEntries;
import com.bawnorton.configurable.processor.entry.ConfigurableEntry;
import com.bawnorton.configurable.processor.generator.ConfigLoaderGenerator;
import com.google.auto.service.AutoService;
import com.palantir.javapoet.JavaFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.bawnorton.configurable.Configurable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
@AutoService(value={Processor.class})
public class ConfigurableProcessor
extends AbstractProcessor {
    private ConfigurableSettings settings;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Configurable.class);
        if (elements.isEmpty()) {
            return false;
        }
        this.loadSettings(this.processingEnv);
        if (this.settings == null) {
            return true;
        }
        ConfigurableEntries entries = ConfigurableEntries.fromElements(elements, this.settings, this.processingEnv);
        if (entries == null) {
            return true;
        }
        ConfigLoaderGenerator generator = new ConfigLoaderGenerator(this.processingEnv, this.settings);
        for (ConfigurableEntry entry : entries) {
            generator.addEntry(entry);
        }
        if (generator.isEmpty()) {
            return true;
        }
        try {
            JavaFile generated = generator.generate();
            generated.writeTo(this.processingEnv.getFiler());
            this.processingEnv.getMessager().printNote("Generated config loader for '%s'.".formatted(this.settings.name()));
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printError("Failed to generate config loader:\n%s: %s".formatted(e.getClass().getCanonicalName(), e.getMessage()));
        }
        return true;
    }

    private void loadSettings(ProcessingEnvironment processingEnv) {
        if (this.settings != null) {
            return;
        }
        Messager messager = processingEnv.getMessager();
        Path projectDir = Path.of(System.getProperty("user.dir"), new String[0]);
        Path configPath = projectDir.resolve("configurable.properties");
        try (FileInputStream configStream = new FileInputStream(configPath.toFile());){
            Properties properties = new Properties();
            properties.load(configStream);
            try {
                this.settings = ConfigurableSettings.fromProperties(properties);
            }
            catch (IllegalArgumentException e) {
                messager.printError("Invalid configurable.properties: %s".formatted(e.getMessage()));
            }
        }
        catch (IOException e) {
            messager.printError("Failed to read configurable.properties:\n%s: %s".formatted(e.getClass().getCanonicalName(), e.getMessage()));
        }
        if (this.settings == null) {
            return;
        }
        Filer filer = processingEnv.getFiler();
        String propertiesFile = "META-INF/configurable.properties";
        try {
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", propertiesFile, new Element[0]);
            try (OutputStream out = fileObject.openOutputStream();){
                Properties properties = this.settings.toProperties();
                properties.store(out, "Generated by ConfigurableProcessor");
            }
        }
        catch (IOException e) {
            messager.printError("Failed to write configurable.properties:\n%s: %s".formatted(e.getClass().getCanonicalName(), e.getMessage()));
        }
    }
}

