/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.block;

import com.finchy.pipeorgans.block.WindchestMasterBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindchestBlock
extends Block
implements IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public WindchestBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.block();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, POWERED});
    }

    public boolean isMasterWindy(Level level, Direction facing, BlockPos pos) {
        BlockPos masterPos = this.getMasterPos(level, facing, pos);
        if (masterPos != pos) {
            return (Boolean)level.getBlockState(masterPos).getValue((Property)WindchestMasterBlock.WINDY);
        }
        return false;
    }

    public boolean isMasterPowered(Level level, Direction facing, BlockPos pos) {
        BlockPos masterPos = this.getMasterPos(level, facing, pos);
        if (masterPos != pos) {
            return (Boolean)level.getBlockState(masterPos).getValue((Property)POWERED);
        }
        return false;
    }

    public boolean isMasterActive(Level level, Direction facing, BlockPos pos) {
        BlockPos masterPos = this.getMasterPos(level, facing, pos);
        BlockState masterState = level.getBlockState(masterPos);
        if (masterPos != pos) {
            return (Boolean)masterState.getValue((Property)POWERED) != false && (Boolean)masterState.getValue((Property)WindchestMasterBlock.WINDY) != false;
        }
        return false;
    }

    public BlockPos getMasterPos(Level level, Direction facing, BlockPos pos) {
        BlockPos currentPos = pos;
        for (int i = 0; i <= 12; ++i) {
            BlockState currentBlock = level.getBlockState(currentPos = currentPos.relative(facing));
            if (currentBlock.getBlock() instanceof WindchestMasterBlock && currentBlock.getValue((Property)FACING) == facing.getOpposite()) {
                return currentPos;
            }
            if (!(currentBlock.getBlock() instanceof WindchestBlock) || currentBlock.getValue((Property)FACING) != facing) break;
        }
        return pos;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult result = super.onWrenched(state, context);
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        state = level.getBlockState(clickedPos);
        boolean shouldPower = this.isMasterPowered(level, (Direction)state.getValue((Property)FACING), clickedPos);
        level.setBlock(clickedPos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(shouldPower)), 3);
        return result;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level level = pContext.getLevel();
        BlockPos clickedPos = pContext.getClickedPos();
        Direction facing = pContext.getHorizontalDirection();
        Direction direction = pContext.getPlayer().isShiftKeyDown() ? facing.getOpposite() : facing;
        return (BlockState)((BlockState)Objects.requireNonNull(super.getStateForPlacement(pContext)).setValue((Property)FACING, (Comparable)direction)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(this.isMasterPowered(level, direction, clickedPos)));
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if (pPos.relative(facing).equals((Object)pNeighborPos)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(this.isMasterPowered(pLevel, facing, pPos))), 3);
        }
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

