/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.optimizations.fast_weather;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import me.flashyreese.mods.sodiumextra.client.render.vertex.formats.WeatherVertex;
import me.flashyreese.mods.sodiumextra.common.util.Utils;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=1500)
public class MixinLevelRenderer {
    @Shadow
    @Final
    private static ResourceLocation RAIN_LOCATION;
    @Shadow
    @Final
    private static ResourceLocation SNOW_LOCATION;
    @Unique
    private final Long2ReferenceMap<Biome> biomeLong2ReferenceMap = new Long2ReferenceOpenHashMap();
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private int ticks;
    @Shadow
    @Final
    private float[] rainSizeX;
    @Shadow
    @Final
    private float[] rainSizeZ;

    @Inject(method={"renderSnowAndRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void sodiumExtra$renderWeather(LightTexture lightTexture, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        assert (this.minecraft.level != null);
        float rainGradient = this.minecraft.level.getRainLevel(tickDelta);
        if (rainGradient > 0.0f) {
            lightTexture.turnOnLightLayer();
            ClientLevel world = this.minecraft.level;
            int cameraPosX = Mth.floor((double)cameraX);
            int cameraPosY = Mth.floor((double)cameraY);
            int cameraPosZ = Mth.floor((double)cameraZ);
            Tesselator tessellator = Tesselator.getInstance();
            BufferBuilder bufferBuilder = null;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int range = Minecraft.useFancyGraphics() ? 10 : 5;
            RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
            int precipitationType = -1;
            float time = (float)this.ticks + tickDelta;
            RenderSystem.setShader(GameRenderer::getParticleShader);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int z = cameraPosZ - range; z <= cameraPosZ + range; ++z) {
                for (int x = cameraPosX - range; x <= cameraPosX + range; ++x) {
                    int positionIndex = (z - cameraPosZ + 16) * 32 + x - cameraPosX + 16;
                    double offsetX = (double)this.rainSizeX[positionIndex] * 0.5;
                    double offsetZ = (double)this.rainSizeZ[positionIndex] * 0.5;
                    mutable.set((double)x, cameraY, (double)z);
                    long biomePacked = Utils.packPosition(x, z);
                    Biome biome = (Biome)this.biomeLong2ReferenceMap.computeIfAbsent(biomePacked, arg_0 -> MixinLevelRenderer.lambda$sodiumExtra$renderWeather$0((Level)world, mutable, arg_0));
                    if (!biome.hasPrecipitation()) continue;
                    int topY = world.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
                    int minY = cameraPosY - range;
                    int maxY = cameraPosY + range;
                    if (minY < topY) {
                        minY = topY;
                    }
                    if (maxY < topY) {
                        maxY = topY;
                    }
                    int adjustedTopY = Math.max(topY, cameraPosY);
                    if (minY == maxY) continue;
                    RandomSource random = RandomSource.create((long)((long)x * (long)x * 3121L + (long)x * 45238971L ^ (long)z * (long)z * 418711L + (long)z * 13761L));
                    mutable.set(x, minY, z);
                    Biome.Precipitation precipitation = biome.getPrecipitationAt((BlockPos)mutable);
                    if (precipitation == Biome.Precipitation.RAIN) {
                        if (precipitationType != 0) {
                            if (precipitationType >= 0) {
                                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                            }
                            precipitationType = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RAIN_LOCATION);
                            bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                        }
                        int ticksModulus = this.ticks & 0x1FFFF;
                        int randomOffset = x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0xFF;
                        float dropLength = 3.0f + random.nextFloat();
                        float dropTimeOffset = -((float)(ticksModulus + randomOffset) + tickDelta) / 32.0f * dropLength;
                        float dropTextureOffset = dropTimeOffset % 32.0f;
                        double relativeX = (double)x + 0.5 - cameraX;
                        double relativeZ = (double)z + 0.5 - cameraZ;
                        float distance = (float)Math.sqrt(relativeX * relativeX + relativeZ * relativeZ) / (float)range;
                        float alpha = ((1.0f - distance * distance) * 0.5f + 0.5f) * rainGradient;
                        mutable.set(x, adjustedTopY, z);
                        int color = ColorABGR.pack((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                        int light = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)mutable);
                        VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
                        this.write(writer, cameraX, cameraY, cameraZ, x, z, offsetX, offsetZ, minY, maxY, 0.0f, dropTextureOffset, color, light);
                        continue;
                    }
                    if (precipitation != Biome.Precipitation.SNOW) continue;
                    if (precipitationType != 1) {
                        if (precipitationType >= 0) {
                            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
                        }
                        precipitationType = 1;
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_LOCATION);
                        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    float snowFallSpeed = -((float)(this.ticks & 0x1FF) + tickDelta) / 512.0f;
                    float snowTextureOffsetX = (float)(random.nextDouble() + (double)time * 0.01 * (double)((float)random.nextGaussian()));
                    float snowTextureOffsetY = (float)(random.nextDouble() + (double)(time * (float)random.nextGaussian()) * 0.001);
                    double relativeX = (double)x + 0.5 - cameraX;
                    double relativeZ = (double)z + 0.5 - cameraZ;
                    float distance = (float)Math.sqrt(relativeX * relativeX + relativeZ * relativeZ) / (float)range;
                    float alpha = ((1.0f - distance * distance) * 0.3f + 0.5f) * rainGradient;
                    mutable.set(x, adjustedTopY, z);
                    int light = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)mutable);
                    int blockLight = light >> 16 & 0xFFFF;
                    int skyLight = light & 0xFFFF;
                    int adjustedBlockLight = (blockLight * 3 + 240) / 4;
                    int adjustedSkyLight = (skyLight * 3 + 240) / 4;
                    VertexBufferWriter writer = VertexBufferWriter.of((VertexConsumer)bufferBuilder);
                    int color = ColorABGR.pack((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    int packedLight = Utils.packLight(adjustedSkyLight, adjustedBlockLight);
                    this.write(writer, cameraX, cameraY, cameraZ, x, z, offsetX, offsetZ, minY, maxY, snowTextureOffsetX, snowFallSpeed + snowTextureOffsetY, color, packedLight);
                }
            }
            if (precipitationType >= 0) {
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            lightTexture.turnOffLightLayer();
        }
        ci.cancel();
    }

    @Inject(method={"allChanged"}, at={@At(value="TAIL")})
    private void postReload(CallbackInfo ci) {
        this.biomeLong2ReferenceMap.clear();
    }

    @Unique
    private void write(VertexBufferWriter writer, double cameraX, double cameraY, double cameraZ, int x, int z, double offsetX, double offsetZ, int minY, int maxY, float textureOffsetX, float textureOffsetY, int color, int light) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            WeatherVertex.put(ptr, (float)((double)x - cameraX - offsetX + 0.5), (float)((double)maxY - cameraY), (float)((double)z - cameraZ - offsetZ + 0.5), 0.0f + textureOffsetX, (float)minY * 0.25f + textureOffsetY, color, light);
            WeatherVertex.put(ptr += 28L, (float)((double)x - cameraX + offsetX + 0.5), (float)((double)maxY - cameraY), (float)((double)z - cameraZ + offsetZ + 0.5), 1.0f + textureOffsetX, (float)minY * 0.25f + textureOffsetY, color, light);
            WeatherVertex.put(ptr += 28L, (float)((double)x - cameraX + offsetX + 0.5), (float)((double)minY - cameraY), (float)((double)z - cameraZ + offsetZ + 0.5), 1.0f + textureOffsetX, (float)maxY * 0.25f + textureOffsetY, color, light);
            WeatherVertex.put(ptr += 28L, (float)((double)x - cameraX - offsetX + 0.5), (float)((double)minY - cameraY), (float)((double)z - cameraZ - offsetZ + 0.5), 0.0f + textureOffsetX, (float)maxY * 0.25f + textureOffsetY, color, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, WeatherVertex.FORMAT);
        }
    }

    private static /* synthetic */ Biome lambda$sodiumExtra$renderWeather$0(Level world, BlockPos.MutableBlockPos mutable, long key) {
        return (Biome)world.getBiome((BlockPos)mutable).value();
    }
}

