/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.shaders;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;

public class ShadersHelper {
    private static List<Triple<String, UniformType, Supplier<?>>> UNIFORMS;

    public static int ShaderLight() {
        return ShadersHelper.isShaderActive() ? 8 : 4;
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.getInstance().getTextureManager().bindForSetup(resourceLocation);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
    }

    public static boolean isShaderActive() {
        return IrisHelper.isLoaded() && IrisHelper.isShaderActive() || OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive();
    }

    public static boolean needsSameSizeBuffers() {
        return OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive();
    }

    public static boolean isRenderingShadows() {
        return IrisHelper.isLoaded() && IrisHelper.isShaderActive() && IrisHelper.isRenderingShadows() || OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive() && OptifineHelper.isRenderingShadows();
    }

    public static void maybeReloadShaders() {
        if (IrisHelper.isLoaded()) {
            IrisHelper.reload();
        }
    }

    public static void addMacros(Consumer<String> createMacro, BiConsumer<String, Integer> createValueMacro) {
        createMacro.accept("VIVECRAFT");
        for (RenderPass pass : RenderPass.values()) {
            createValueMacro.accept("VIVECRAFT_PASS_" + pass.toString(), pass.ordinal());
        }
    }

    public static List<Triple<String, UniformType, Supplier<?>>> getUniforms() {
        if (UNIFORMS == null) {
            UNIFORMS = new ArrayList();
            ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
            Minecraft mc = Minecraft.getInstance();
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeMainHandPos", (Object)((Object)UniformType.VECTOR3F), () -> {
                if (VRState.VR_RUNNING) {
                    return MathUtils.subtractToVector3f(mc.gameRenderer.getMainCamera().getPosition(), RenderHelper.getControllerRenderPos(0));
                }
                return MathUtils.ZERO;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeMainHandRot", (Object)((Object)UniformType.MATRIX4F), () -> {
                if (VRState.VR_RUNNING) {
                    return dh.vrPlayer.getVRDataWorld().getController(0).getMatrix();
                }
                return MathUtils.IDENTITY;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeOffHandPos", (Object)((Object)UniformType.VECTOR3F), () -> {
                if (VRState.VR_RUNNING) {
                    return MathUtils.subtractToVector3f(mc.gameRenderer.getMainCamera().getPosition(), RenderHelper.getControllerRenderPos(1));
                }
                return MathUtils.ZERO;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftRelativeOffHandRot", (Object)((Object)UniformType.MATRIX4F), () -> {
                if (VRState.VR_RUNNING) {
                    return dh.vrPlayer.getVRDataWorld().getController(1).getMatrix();
                }
                return MathUtils.IDENTITY;
            }));
            UNIFORMS.add(Triple.of((Object)"vivecraftIsVR", (Object)((Object)UniformType.BOOLEAN), () -> VRState.VR_RUNNING));
            UNIFORMS.add(Triple.of((Object)"vivecraftRenderpass", (Object)((Object)UniformType.INTEGER), () -> ClientDataHolderVR.getInstance().currentPass.ordinal()));
        }
        return UNIFORMS;
    }

    public static enum UniformType {
        MATRIX4F,
        VECTOR3F,
        INTEGER,
        BOOLEAN;

    }
}

