/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.multiplayer;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.settings.VRSettings;

@Mixin(value={MultiPlayerGameMode.class})
public class MultiPlayerGameModeVRMixin {
    @WrapMethod(method={"useItem(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"})
    private InteractionResult vivecraft$useLookOverride(Player player, InteractionHand hand, Operation<InteractionResult> original) {
        return this.vivecraft$wrapWithLookOverride(() -> (InteractionResult)original.call(new Object[]{player, hand}), player, () -> ClientDataHolderVR.getInstance().vrPlayer.getRightClickLookOverride(player, hand.ordinal()));
    }

    @WrapMethod(method={"releaseUsingItem(Lnet/minecraft/world/entity/player/Player;)V"})
    private void vivecraft$releaseUseLookOverride(Player player, Operation<Void> original) {
        this.vivecraft$wrapWithLookOverride(() -> (Void)original.call(new Object[]{player}), player, () -> ClientDataHolderVR.getInstance().vrPlayer.getRightClickLookOverride(player, player.getUsedItemHand().ordinal()));
    }

    @WrapMethod(method={"useItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"})
    private InteractionResult vivecraft$useOnLookOverride(LocalPlayer player, InteractionHand hand, BlockHitResult result, Operation<InteractionResult> original) {
        return this.vivecraft$wrapWithLookOverride(() -> (InteractionResult)original.call(new Object[]{player, hand, result}), (Player)player, () -> ClientDataHolderVR.getInstance().vrPlayer.getRightClickLookOverride((Player)player, hand.ordinal()));
    }

    @Unique
    private <T> T vivecraft$wrapWithLookOverride(Supplier<T> useCall, Player player, Supplier<Vec3> viewSupplier) {
        if (VRState.VR_RUNNING) {
            ClientNetworking.overrideLook(player, viewSupplier);
        }
        T result = useCall.get();
        if (VRState.VR_RUNNING) {
            ClientNetworking.restoreLook();
        }
        return result;
    }

    @WrapOperation(method={"lambda$useItem$5(Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/entity/player/Player;Lorg/apache/commons/lang3/mutable/MutableObject;I)Lnet/minecraft/network/protocol/Packet;"}, at={@At(value="NEW", target="Lnet/minecraft/network/protocol/game/ServerboundUseItemPacket;")})
    private ServerboundUseItemPacket vivecraft$lookOverridePacket(InteractionHand hand, int sequence, float yRot, float xRot, Operation<ServerboundUseItemPacket> original) {
        if (VRState.VR_RUNNING) {
            if (ClientNetworking.OVERRIDE_ACTIVE) {
                yRot = ClientNetworking.OVERRIDDEN_YAW;
                xRot = ClientNetworking.OVERRIDDEN_PITCH;
            } else {
                VRBodyPart bp = ClientNetworking.IS_LAST_BODY_PART_AIM ? ClientNetworking.getActiveBodyPart() : (ClientDataHolderVR.getInstance().vrSettings.aimDevice == VRSettings.AimDevice.HMD ? VRBodyPart.HEAD : VRBodyPart.MAIN_HAND);
                Vector3f dir = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyPart(bp).getDirection();
                yRot = (float)Math.toDegrees(Math.atan2(-dir.x, dir.z));
                xRot = (float)Math.toDegrees(Math.asin(-dir.y / dir.length()));
            }
        }
        return (ServerboundUseItemPacket)original.call(new Object[]{hand, sequence, Float.valueOf(yRot), Float.valueOf(xRot)});
    }

    @WrapMethod(method={"sameDestroyTarget(Lnet/minecraft/core/BlockPos;)Z"})
    private boolean vivecraft$dualWieldingSkipItemCheck(BlockPos pos, Operation<Boolean> original) {
        if (VRState.VR_RUNNING && ClientNetworking.SERVER_ALLOWS_DUAL_WIELDING) {
            ClientNetworking.BODY_PART_CLIENT_OVERRIDE = VRBodyPart.MAIN_HAND;
            boolean sameItem = (Boolean)original.call(new Object[]{pos});
            ClientNetworking.BODY_PART_CLIENT_OVERRIDE = VRBodyPart.OFF_HAND;
            ClientNetworking.BODY_PART_CLIENT_OVERRIDE = null;
            return sameItem |= ((Boolean)original.call(new Object[]{pos})).booleanValue();
        }
        return (Boolean)original.call(new Object[]{pos});
    }
}

