/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.player;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.network.SupporterReceiver;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.mixin.client_vr.world.entity.LivingEntityMixin;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends LivingEntityMixin {
    public AbstractClientPlayerMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/multiplayer/ClientLevel;Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void vivecraft$addPatreonInfo(CallbackInfo ci) {
        SupporterReceiver.addPlayerInfo((Player)((AbstractClientPlayer)this));
    }

    @Override
    protected void vivecraft$modifyEatParticles(Level instance, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (this == Minecraft.getInstance().player && VRState.VR_RUNNING) {
            Vec3 pos = RenderHelper.getControllerRenderPos(this.getUsedItemHand() == InteractionHand.MAIN_HAND ? 0 : 1);
            Vector3f dir = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().hmd.getDirection();
            this.vivecraft$particlesWithRandomOffset(instance, particleData, original, pos, (Vector3fc)dir);
        } else {
            ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getLatestRotationsForPlayer(this.uuid);
            if (rotInfo != null) {
                Vec3 pos = this.getUsedItemHand() == InteractionHand.MAIN_HAND ? this.position().add((double)rotInfo.mainHandPos.x(), (double)rotInfo.mainHandPos.y(), (double)rotInfo.mainHandPos.z()) : this.position().add((double)rotInfo.offHandPos.x(), (double)rotInfo.offHandPos.y(), (double)rotInfo.offHandPos.z());
                Vector3fc dir = rotInfo.headRot;
                this.vivecraft$particlesWithRandomOffset(instance, particleData, original, pos, dir);
            } else {
                original.call(new Object[]{instance, particleData, x, y, z, xSpeed, ySpeed, zSpeed});
            }
        }
    }

    @Unique
    private void vivecraft$particlesWithRandomOffset(Level instance, ParticleOptions particleData, Operation<Void> original, Vec3 pos, Vector3fc dir) {
        float yOffset = this.random.nextFloat() * 0.2f - 0.1f;
        float xOffset = this.random.nextFloat() * 0.2f - 0.1f;
        float zOffset = this.random.nextFloat() * 0.2f - 0.1f;
        original.call(new Object[]{instance, particleData, pos.x + (double)yOffset, pos.y + (double)xOffset, pos.z + (double)zOffset, (double)(dir.x() * 0.1f + yOffset * 0.5f), (double)(dir.y() * 0.1f + xOffset * 0.5f + 0.1f), (double)(dir.z() * 0.1f + zOffset * 0.5f)});
    }
}

