/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.utils.osc_trackers;

import com.illposed.osc.MessageSelector;
import com.illposed.osc.OSCMessageEvent;
import com.illposed.osc.messageselector.OSCPatternAddressMessageSelector;
import com.illposed.osc.transport.OSCPortIn;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_vr.utils.osc_trackers.OSCTracker;
import org.vivecraft.common.utils.MathUtils;

public class OSCTrackerReceiver {
    private OSCPortIn portIn;
    public final OSCTracker[] trackers = new OSCTracker[8];
    private final MCVR mcvr;
    private final Vector3f offset = new Vector3f();
    private float rotationOffset = 0.0f;
    private long headTimestamp = 0L;

    public OSCTrackerReceiver(MCVR mcvr) {
        this.mcvr = mcvr;
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i] = new OSCTracker();
        }
        this.changePort(ClientDataHolderVR.getInstance().vrSettings.oscTrackerPort);
    }

    public void changePort(int port) {
        this.stop();
        try {
            this.portIn = new OSCPortIn(port);
            VRSettings.LOGGER.info("Vivecraft: start listening for OSC trackers on port: {}", (Object)port);
            this.portIn.getDispatcher().addListener((MessageSelector)new OSCPatternAddressMessageSelector("/tracking/trackers/*/position"), this::handlePositionMessage);
            this.portIn.getDispatcher().addListener((MessageSelector)new OSCPatternAddressMessageSelector("/tracking/trackers/*/rotation"), this::handleRotationMessage);
            this.portIn.startListening();
        }
        catch (IOException e) {
            VRSettings.LOGGER.error("Vivecraft: Failed to start OSC receiver", (Throwable)e);
        }
    }

    public void stop() {
        if (this.portIn != null) {
            this.portIn.stopListening();
            this.portIn = null;
        }
    }

    public boolean hasTrackers() {
        return Arrays.stream(this.trackers).anyMatch(OSCTracker::isTracking);
    }

    private void handlePositionMessage(OSCMessageEvent event) {
        int index = this.getMessageTrackerIndex(event.getMessage().getAddress());
        List args = event.getMessage().getArguments();
        if (index == 0) {
            this.offset.set(-((Float)args.get(0)).floatValue(), -((Float)args.get(1)).floatValue(), ((Float)args.get(2)).floatValue());
        } else {
            OSCTracker target = this.trackers[index - 1];
            Vector3f translation = new Vector3f(((Float)args.get(0)).floatValue(), ((Float)args.get(1)).floatValue(), -((Float)args.get(2)).floatValue());
            translation.add((Vector3fc)this.offset);
            translation.rotateY(this.rotationOffset);
            if (!this.mcvr.hmdPivotHistory.isEmpty()) {
                translation.add(this.mcvr.hmdPivotHistory.latest());
            }
            target.pose.setTranslation((Vector3fc)translation);
            target.timeStamp = System.currentTimeMillis();
        }
    }

    private void handleRotationMessage(OSCMessageEvent event) {
        int index = this.getMessageTrackerIndex(event.getMessage().getAddress());
        List args = event.getMessage().getArguments();
        if (index == 0) {
            Vector3f hmdDir = this.mcvr.getHmdVector();
            Vector3f fwd = new Matrix4f().rotationZ((float)Math.PI / 180 * -((Float)args.get(2)).floatValue()).rotateX((float)Math.PI / 180 * ((Float)args.get(0)).floatValue()).rotateY((float)Math.PI / 180 * ((Float)args.get(1)).floatValue()).transformDirection(MathUtils.BACK, new Vector3f());
            float newRot = (float)Math.atan2(-fwd.x, fwd.z) - (float)Math.atan2(-hmdDir.x, hmdDir.z);
            this.rotationOffset = System.currentTimeMillis() - this.headTimestamp < 300L ? MathUtils.rotLerpRad(0.01f, this.rotationOffset, newRot) : newRot;
            this.headTimestamp = System.currentTimeMillis();
        } else {
            OSCTracker target = this.trackers[index - 1];
            float x = target.pose.m30();
            float y = target.pose.m31();
            float z = target.pose.m32();
            target.pose.rotationZ((float)Math.PI / 180 * -((Float)args.get(2)).floatValue()).rotateX((float)Math.PI / 180 * ((Float)args.get(0)).floatValue()).rotateY((float)Math.PI / 180 * ((Float)args.get(1)).floatValue()).rotateLocalY(this.rotationOffset).setTranslation(x, y, z);
            target.timeStamp = System.currentTimeMillis();
        }
    }

    private int getMessageTrackerIndex(String address) {
        char tracker = address.charAt(19);
        if (tracker == 'h') {
            return 0;
        }
        return Integer.parseInt(String.valueOf(tracker));
    }
}

