/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.gui.keyboard.EasterEggTheme;
import org.vivecraft.client_vr.gui.keyboard.KeyboardKeys;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.utils.RGBAColor;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class PhysicalKeyboard {
    private static final float SPACING = 0.0064f;
    private static final float KEY_WIDTH = 0.04f;
    private static final float KEY_HEIGHT = 0.04f;
    private static final float KEY_WIDTH_SPECIAL = 0.086399995f;
    private final Minecraft mc = Minecraft.getInstance();
    private final ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    private boolean reinit;
    private boolean shift;
    private boolean shiftSticky;
    private final List<KeyButton> keys;
    private int rows;
    private int columns;
    private float spacing;
    private float keyWidth;
    private float keyHeight;
    private float keyWidthSpecial;
    private float scale = 1.0f;
    private final KeyButton[] pressedKey = new KeyButton[2];
    private final long[] pressTime = new long[2];
    private final long[] pressRepeatTime = new long[2];
    private long shiftPressTime;
    private boolean lastPressedShift;
    private Supplier<String> easterEggText = () -> {
        int[] data = new int[]{188, 161, 183, 175, 162, 238, 188, 175, 167, 160, 172, 161, 185};
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = (byte)(data[i] ^ 0xCE);
        }
        String str = new String(bytes, StandardCharsets.UTF_8);
        this.easterEggText = () -> str;
        return str;
    };
    private int easterEggIndex = 0;
    private boolean easterEggActive;
    private final Map<Integer, RGBAColor> customTheme = new HashMap<Integer, RGBAColor>();

    public PhysicalKeyboard() {
        this.keys = new ArrayList<KeyButton>();
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        void var3_6;
        this.unpressAllKeys();
        this.keys.clear();
        this.spacing = 0.0064f * this.scale;
        this.keyWidth = 0.04f * this.scale;
        this.keyHeight = 0.04f * this.scale;
        this.keyWidthSpecial = 0.086399995f * this.scale;
        KeyboardKeys.Layout layout = KeyboardKeys.getRegularKeys(this.shift, () -> {
            if (!this.shiftSticky) {
                this.setShift(false, false);
            }
        });
        this.rows = layout.rows();
        this.columns = layout.columns();
        for (KeyboardKeys.Key key : layout.keys()) {
            int y = key.y() < 0 ? this.rows - key.y() : key.y();
            this.addKey(new KeyButton((float)key.x() * (this.keyWidth + this.spacing), (float)(y - 1) * (this.keyHeight + this.spacing), (float)key.width() * this.keyWidth + (float)(key.width() - 1) * this.spacing, (float)key.height() * this.keyHeight + (float)(key.height() - 1) * this.spacing, key));
        }
        List<KeyboardKeys.Key> specialKeys = KeyboardKeys.getSpecialKeys(() -> {
            if (this.shift && !this.shiftSticky && ClientUtils.milliTime() - this.shiftPressTime < 400L) {
                this.setShift(true, true);
            } else {
                this.setShift(!this.shift, false);
            }
            this.shiftPressTime = ClientUtils.milliTime();
        });
        for (KeyboardKeys.Key key : specialKeys) {
            int y = key.y() < 0 ? this.rows - key.y() : key.y();
            this.addKey(new KeyButton((float)key.x() * (this.keyWidth + this.spacing), (float)(y - 1) * (this.keyHeight + this.spacing), (float)key.width() * this.keyWidth + (float)(key.width() - 1) * this.spacing, (float)key.height() * this.keyHeight, key){

                @Override
                public RGBAColor getRenderColor() {
                    if (this.key.isShift() && PhysicalKeyboard.this.shift) {
                        RGBAColor color = new RGBAColor(this.pressed ? 1.0f : 0.5f, this.pressed ? 1.0f : 0.5f, 0.0f, 0.5f);
                        if (!PhysicalKeyboard.this.shiftSticky) {
                            color.r = 0.0f;
                        }
                        return color;
                    }
                    return super.getRenderColor();
                }
            });
        }
        boolean bl = false;
        while (var3_6 < 2) {
            if (this.pressedKey[var3_6] != null) {
                for (KeyButton key : this.keys) {
                    if (key.key.id() != this.pressedKey[var3_6].key.id()) continue;
                    this.pressedKey[var3_6] = key;
                    key.pressed = true;
                    break;
                }
            }
            ++var3_6;
        }
        this.dh.vrSettings.physicalKeyboardTheme.theme.reload();
        this.reinit = false;
    }

    public void process() {
        if (this.reinit) {
            this.init();
        }
        for (int c = 0; c < 2; ++c) {
            ControllerType controller = ControllerType.values()[c];
            KeyButton key = this.findTouchedKey(controller);
            long milliTime = ClientUtils.milliTime();
            if (key != null) {
                if (key != this.pressedKey[c] && milliTime - this.pressTime[c] >= 150L) {
                    if (this.pressedKey[c] != null) {
                        this.pressedKey[c].unpress();
                        this.pressedKey[c] = null;
                    }
                    key.press(controller, false);
                    this.pressedKey[c] = key;
                    this.pressTime[c] = milliTime;
                    this.pressRepeatTime[c] = milliTime;
                    continue;
                }
                if (key != this.pressedKey[c] || milliTime - this.pressTime[c] < 500L || milliTime - this.pressRepeatTime[c] < 100L) continue;
                key.press(controller, true);
                this.pressRepeatTime[c] = milliTime;
                continue;
            }
            if (this.pressedKey[c] == null) continue;
            this.pressedKey[c].unpress();
            this.pressedKey[c] = null;
            this.pressTime[c] = milliTime;
        }
    }

    public void processBindings() {
        if (GuiHandler.KEY_KEYBOARD_SHIFT.consumeClick()) {
            this.setShift(true, true);
            this.lastPressedShift = true;
        }
        if (!GuiHandler.KEY_KEYBOARD_SHIFT.isDown() && this.lastPressedShift) {
            this.setShift(false, false);
            this.lastPressedShift = false;
        }
    }

    private Vector3f getCenterPos() {
        return new Vector3f(((this.keyWidth + this.spacing) * ((float)this.columns + (float)this.columns % 2.0f / 2.0f) + (this.keyWidthSpecial + this.spacing) * 2.0f) / 2.0f, (this.keyHeight + this.spacing) * (float)(this.rows + 1), 0.0f);
    }

    private KeyButton findTouchedKey(ControllerType controller) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate((Vector3fc)this.getCenterPos());
        matrix.mul((Matrix4fc)new Matrix4f((Matrix4fc)KeyboardHandler.ROTATION_ROOM).invert());
        matrix.translate(-KeyboardHandler.POS_ROOM.x, -KeyboardHandler.POS_ROOM.y, -KeyboardHandler.POS_ROOM.z);
        Vector3f pos = matrix.transformPosition(this.dh.vrPlayer.vrdata_room_pre.getController(controller.ordinal()).getPositionF());
        for (KeyButton key : this.keys) {
            if (!key.getCollisionBoundingBox().contains((double)pos.x, (double)pos.y, (double)pos.z)) continue;
            return key;
        }
        return null;
    }

    private void updateEasterEgg(String label) {
        String text = this.easterEggText.get();
        if (this.easterEggIndex < text.length()) {
            this.easterEggIndex = label.toLowerCase().equals(String.valueOf(text.charAt(this.easterEggIndex))) ? ++this.easterEggIndex : 0;
        } else if (label.equals("Enter")) {
            this.easterEggActive = !this.easterEggActive;
        } else {
            this.easterEggIndex = 0;
        }
    }

    private void drawBox(BufferBuilder buf, AABB box, RGBAColor color, Matrix4f matrix) {
        float minX = (float)box.minX;
        float minY = (float)box.minY;
        float minZ = (float)box.minZ;
        float maxX = (float)box.maxX;
        float maxY = (float)box.maxY;
        float maxZ = (float)box.maxZ;
        buf.addVertex(matrix, minX, minY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, maxY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, maxY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, minY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, minY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, minY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, minY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, minY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, minY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, minY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, maxY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, maxY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, maxY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, maxY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, minY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, minY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, maxY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, maxY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, maxY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, minX, maxY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, maxY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, minY, maxZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, minY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
        buf.addVertex(matrix, maxX, maxY, minZ).setUv(0.0f, 0.0f).setColor(color.r, color.g, color.b, color.a);
    }

    public void render(Matrix4fStack poseStack) {
        if (this.keys.isEmpty()) {
            return;
        }
        poseStack.pushMatrix();
        Vector3f center = this.getCenterPos();
        poseStack.translate(-center.x, -center.y, -center.z);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        EasterEggTheme theme = this.easterEggActive ? EasterEggTheme.INSTANCE : this.dh.vrSettings.physicalKeyboardTheme.theme;
        for (KeyButton button : this.keys) {
            theme.updateColor(button.color, button.key.id(), button.key.x(), button.key.y());
        }
        RenderSystem.depthFunc((int)519);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Font font = this.mc.font;
        ArrayList<Tuple> labels = new ArrayList<Tuple>();
        float textScale = 0.002f * this.scale;
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buf = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        for (KeyButton key : this.keys) {
            AABB box = key.getRenderBoundingBox();
            RGBAColor color = key.getRenderColor();
            this.drawBox(buf, box, color, (Matrix4f)poseStack);
            float stringWidth = (float)font.width((FormattedText)key.key.label()) * textScale;
            Objects.requireNonNull(font);
            float stringHeight = 9.0f * textScale;
            float textX = (float)box.minX + ((float)box.maxX - (float)box.minX) / 2.0f - stringWidth / 2.0f;
            float textY = (float)box.minY + ((float)box.maxY - (float)box.minY) / 2.0f - stringHeight / 2.0f;
            float textZ = (float)box.minZ + ((float)box.maxZ - (float)box.minZ) / 2.0f;
            labels.add(new Tuple((Object)key.key.label(), (Object)new Vector3f(textX, textY, textZ)));
        }
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        RenderSystem.depthFunc((int)515);
        for (Tuple label : labels) {
            poseStack.pushMatrix();
            poseStack.translate(((Vector3f)label.getB()).x, ((Vector3f)label.getB()).y, ((Vector3f)label.getB()).z);
            poseStack.scale(textScale, textScale, 1.0f);
            font.drawInBatch((Component)label.getA(), 0.0f, 0.0f, -1, false, (Matrix4f)poseStack, (MultiBufferSource)this.mc.renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.popMatrix();
        }
        this.mc.renderBuffers().bufferSource().endBatch();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.defaultBlendFunc();
        poseStack.popMatrix();
    }

    public void show() {
        if (!this.shiftSticky) {
            this.shift = false;
        }
        this.scale = this.dh.vrSettings.physicalKeyboardScale;
        this.reinit = true;
    }

    public void unpressAllKeys() {
        for (KeyButton key : this.keys) {
            if (!key.pressed) continue;
            key.unpress();
        }
    }

    private KeyButton addKey(KeyButton key) {
        this.keys.add(key);
        return key;
    }

    public boolean isShift() {
        return this.shift;
    }

    public boolean isShiftSticky() {
        return this.shiftSticky;
    }

    public void setShift(boolean shift, boolean sticky) {
        if (shift != this.shift || sticky != this.shiftSticky) {
            this.shift = shift;
            this.shiftSticky = shift && sticky;
            this.reinit = true;
        }
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.reinit = true;
    }

    private class KeyButton {
        public final AABB boundingBox;
        public final KeyboardKeys.Key key;
        public RGBAColor color = new RGBAColor(1.0f, 1.0f, 1.0f, 0.5f);
        public boolean pressed;

        public KeyButton(float x, float y, float width, float height, KeyboardKeys.Key key) {
            this.boundingBox = new AABB((double)x, (double)y, 0.0, (double)(x + width), (double)(y + height), 0.028 * (double)PhysicalKeyboard.this.scale);
            this.key = key;
        }

        public AABB getRenderBoundingBox() {
            return this.pressed ? this.boundingBox.move(0.0, 0.0, 0.012 * (double)PhysicalKeyboard.this.scale) : this.boundingBox;
        }

        public AABB getCollisionBoundingBox() {
            return this.pressed ? this.boundingBox.expandTowards(0.0, 0.0, 0.08) : this.boundingBox;
        }

        public RGBAColor getRenderColor() {
            RGBAColor color = this.color.copy();
            if (!this.pressed) {
                color.r *= 0.5f;
                color.g *= 0.5f;
                color.b *= 0.5f;
            }
            return color;
        }

        public final void press(ControllerType controller, boolean isRepeat) {
            if (!isRepeat) {
                PhysicalKeyboard.this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            MCVR.get().triggerHapticPulse(controller, isRepeat ? 300 : 600);
            this.pressed = true;
            this.key.onPress().run();
            PhysicalKeyboard.this.updateEasterEgg(this.key.label().getString());
        }

        public final void unpress() {
            this.pressed = false;
            this.key.onRelease().run();
        }
    }
}

