/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StringSimilarity {
    private static int block_similarity(Map<Character, Integer> block, String s1, String s2) {
        if (s1.isEmpty()) {
            return 0;
        }
        int S = (1 << s1.length()) - 1;
        for (char ch2 : s2.toCharArray()) {
            int Matches = block.getOrDefault(Character.valueOf(ch2), 0);
            int u = S & Matches;
            S = S + u | S - u;
        }
        return 32 - Integer.numberOfLeadingZeros(S) - Integer.bitCount(S);
    }

    private static int block_distance(Map<Character, Integer> block, String s1, String s2) {
        int maximum = s1.length() + s2.length();
        return maximum - 2 * StringSimilarity.block_similarity(block, s1, s2);
    }

    private static float block_normalized_distance(Map<Character, Integer> block, String s1, String s2) {
        float maximum = s1.length() + s2.length();
        return maximum != 0.0f ? (float)StringSimilarity.block_distance(block, s1, s2) / maximum : 0.0f;
    }

    private static float block_normalized_similarity(Map<Character, Integer> block, String s1, String s2, float cutoff) {
        float norm_sim = 1.0f - StringSimilarity.block_normalized_distance(block, s1, s2);
        return norm_sim >= cutoff ? norm_sim : 0.0f;
    }

    public static float partial_ratio(String s1, String s2) {
        char substr_last;
        int i;
        if (s2.length() < s1.length()) {
            String temp = s1;
            s1 = s2;
            s2 = temp;
        }
        HashSet<Character> s1_char_set = new HashSet<Character>();
        for (char c : s1.toCharArray()) {
            s1_char_set.add(Character.valueOf(c));
        }
        int len1 = s1.length();
        int len2 = s2.length();
        float cutoff = 0.0f;
        float res = 0.0f;
        HashMap<Character, Integer> block = new HashMap<Character, Integer>();
        int x = 1;
        for (char ch1 : s1.toCharArray()) {
            block.put(Character.valueOf(ch1), block.getOrDefault(Character.valueOf(ch1), 0) | x);
            x <<= 1;
        }
        for (i = 1; i < len1; ++i) {
            float ls_ratio;
            substr_last = s2.charAt(i - 1);
            if (!s1_char_set.contains(Character.valueOf(substr_last)) || !((ls_ratio = StringSimilarity.block_normalized_similarity(block, s1, s2.substring(0, i), cutoff)) > res) || (res = (cutoff = ls_ratio)) != 1.0f) continue;
            return res;
        }
        for (i = 0; i < len2 - len1; ++i) {
            float ls_ratio;
            substr_last = s2.charAt(i + len1 - 1);
            if (!s1_char_set.contains(Character.valueOf(substr_last)) || !((ls_ratio = StringSimilarity.block_normalized_similarity(block, s1, s2.substring(i, i + len1), cutoff)) > res) || (res = (cutoff = ls_ratio)) != 1.0f) continue;
            return res;
        }
        for (i = len2 - len1; i < len2; ++i) {
            float ls_ratio;
            char substr_first = s2.charAt(i);
            if (!s1_char_set.contains(Character.valueOf(substr_first)) || !((ls_ratio = StringSimilarity.block_normalized_similarity(block, s1, s2.substring(i), cutoff)) > res) || (res = (cutoff = ls_ratio)) != 1.0f) continue;
            return res;
        }
        return res;
    }
}

