/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.block.simple.MercuryCactusBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MercuryCactusFeature
extends Feature<NoneFeatureConfiguration> {
    public MercuryCactusFeature(Codec<NoneFeatureConfiguration> p_65360_) {
        super(p_65360_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        BlockPos pos;
        BlockPos.MutableBlockPos newpos;
        WorldGenLevel level = pContext.level();
        if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)(newpos = (pos = pContext.origin()).mutable())).getY() <= newpos.getY()) {
            return false;
        }
        BlockPos caveCeilingPos = this.scan(Direction.UP, pos, level, 24);
        if (caveCeilingPos == pos) {
            return false;
        }
        int caveHeight = caveCeilingPos.getY() / 2;
        RandomSource rando = pContext.random();
        int i = 0;
        while (i < caveHeight) {
            if (level.getBlockState((BlockPos)newpos).isAir() || level.getBlockState((BlockPos)newpos).canBeReplaced()) {
                level.setBlock((BlockPos)newpos, ((MercuryCactusBlock)((Object)NorthstarBlocks.MERCURY_CACTUS.get())).defaultBlockState(), 3);
            } else {
                i += 99999;
            }
            if (i == caveHeight - 1) {
                this.placeBranch(level, (BlockPos)newpos, rando, (int)((float)caveHeight * 2.2f), Direction.NORTH, rando.nextInt(1, 3));
                this.placeBranch(level, (BlockPos)newpos, rando, (int)((float)caveHeight * 2.2f), Direction.SOUTH, rando.nextInt(1, 3));
                this.placeBranch(level, (BlockPos)newpos, rando, (int)((float)caveHeight * 2.2f), Direction.EAST, rando.nextInt(1, 3));
                this.placeBranch(level, (BlockPos)newpos, rando, (int)((float)caveHeight * 2.2f), Direction.WEST, rando.nextInt(1, 3));
            }
            if (rando.nextInt(4) == 0 && i > 2) {
                newpos.move(Direction.Plane.HORIZONTAL.getRandomDirection(rando));
                continue;
            }
            newpos.move(Direction.UP);
            ++i;
        }
        return true;
    }

    public void placeBranch(WorldGenLevel level, BlockPos pos, RandomSource rando, int height, Direction dir, int dist) {
        BlockPos.MutableBlockPos newpos = pos.mutable();
        for (int i = 0; i < height; ++i) {
            if (i <= dist) {
                newpos.move(dir);
            } else if (rando.nextInt(4) != 0) {
                newpos.move(Direction.UP);
            } else {
                newpos.move(dir);
            }
            if (level.getBlockState((BlockPos)newpos).isAir() || level.getBlockState((BlockPos)newpos).canBeReplaced()) {
                level.setBlock((BlockPos)newpos, ((MercuryCactusBlock)((Object)NorthstarBlocks.MERCURY_CACTUS.get())).defaultBlockState(), 3);
                level.scheduleTick((BlockPos)newpos, (Block)NorthstarBlocks.MERCURY_CACTUS.get(), 2);
                continue;
            }
            i += 99999;
        }
    }

    protected BlockPos scan(Direction dir, BlockPos pos, WorldGenLevel level, int scanDist) {
        BlockPos newblockpos = pos;
        for (int i = 0; i < scanDist; ++i) {
            if (!level.getBlockState(newblockpos = newblockpos.relative(Direction.UP)).isAir() || level.getBlockState(newblockpos.above()).isAir()) continue;
            return newblockpos;
        }
        return pos;
    }
}

