/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.world.features.configuration.BlockPileConfig;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class BlockPileFeature
extends Feature<BlockPileConfig> {
    public BlockPileFeature(Codec<BlockPileConfig> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<BlockPileConfig> pContext) {
        BlockPileConfig config = (BlockPileConfig)pContext.config();
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        RandomSource randomsource = pContext.random();
        boolean flag = false;
        int i = blockpos.getY();
        int j = i + config.halfHeight().sample(randomsource);
        int k = i - config.halfHeight().sample(randomsource) - 1;
        int radius = config.radius().sample(randomsource);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int pp = 0;
        int iteration = 0;
        int old_radius = radius;
        while (radius > old_radius / j) {
            if (pp < config.depth().sample(randomsource)) {
                ++pp;
                blockpos = blockpos.above();
                ++iteration;
            }
            for (BlockPos blockpos1 : BlockPos.betweenClosed((BlockPos)blockpos.offset(-radius, 0, -radius), (BlockPos)blockpos.offset(radius, 0, radius))) {
                int bruhZ;
                int bruhX = blockpos1.getX() - blockpos.getX();
                if (!((double)(bruhX * bruhX + (bruhZ = blockpos1.getZ() - blockpos.getZ()) * bruhZ) <= (double)(radius * radius) - 0.1) || iteration > 3) continue;
                flag |= this.placeColumn(config, worldgenlevel, randomsource, j, k, blockpos$mutableblockpos.set((Vec3i)blockpos1), iteration, radius, pContext.origin().offset(0, 0, 0));
            }
            radius = (int)((double)radius / 1.5);
        }
        return flag;
    }

    protected boolean placeColumn(BlockPileConfig pConfig, WorldGenLevel pLevel, RandomSource pRandom, int pMaxY, int pMinY, BlockPos.MutableBlockPos pPos, int iteration, float radius, BlockPos origin) {
        boolean flag = false;
        BlockState blockstate = pConfig.blockProvider().getState(pRandom, (BlockPos)pPos);
        float dist = (float)Math.abs(Math.sqrt(Math.pow(pPos.getX() - origin.getX(), 2.0) + Math.pow(pPos.getZ() - origin.getZ(), 2.0)));
        Northstar.LOGGER.debug("pPos: {}", (Object)pPos);
        Northstar.LOGGER.debug("origin: {}", (Object)origin);
        Northstar.LOGGER.debug("dist: {}", (Object)Float.valueOf(dist));
        if (radius / 2.0f == 0.0f) {
            Northstar.LOGGER.debug("What the scallop???");
            return false;
        }
        if (iteration == 1) {
            if (pRandom.nextIntBetweenInclusive(0, Math.round(Math.abs((float)((int)dist - 1) / (radius / 2.0f)))) <= 0) {
                pLevel.setBlock(pLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pPos).below(), blockstate, 2);
                pLevel.setBlock(pLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pPos).below().below(), blockstate, 2);
            }
        } else if (pRandom.nextIntBetweenInclusive(0, Math.round(Math.abs((float)((int)dist - 1) / (radius / 2.0f)))) <= 0) {
            pLevel.setBlock(pLevel.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pPos), blockstate, 2);
        }
        this.markAboveForPostProcessing(pLevel, (BlockPos)pPos);
        flag = true;
        return flag;
    }

    protected boolean clearAir(BlockPileConfig pConfig, WorldGenLevel pLevel, RandomSource pRandom, int pMaxY, int pMinY, BlockPos.MutableBlockPos pPos) {
        boolean flag = false;
        BlockState blockstate = pConfig.airProvider().getState(pRandom, (BlockPos)pPos);
        for (int i = 0; i < 12; ++i) {
            pLevel.setBlock(pPos.atY(pPos.getY() + i), blockstate, 2);
            flag = true;
        }
        return flag;
    }
}

