/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.GlowstoneParticleData;
import com.lightning.northstar.particle.NorthstarParticles;
import com.simibubi.create.content.equipment.bell.BasicParticleData;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class GlowstoneParticle
extends SimpleAnimatedParticle {
    protected GlowstoneParticle(ClientLevel world, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.random.nextFloat() * 0.5f);
        this.quadSize *= 0.75f;
        this.lifetime = 40;
        this.hasPhysics = false;
        this.selectSprite(7);
        Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)world.random, (float)0.25f);
        this.setPos(x + offset.x, y + offset.y, z + offset.z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setAlpha(0.25f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private void selectSprite(int index) {
        this.setSprite(this.sprites.get(index, 8));
    }

    public void move(double pX, double pY, double pZ) {
    }

    public float getQuadSize(float pScaleFactor) {
        float f = ((float)this.age + pScaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f * 0.5f);
    }

    public int getLightColor(float pPartialTick) {
        float f = ((float)this.age + pPartialTick) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(pPartialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Data
    extends BasicParticleData<GlowstoneParticle> {
        public BasicParticleData.IBasicParticleFactory<GlowstoneParticle> getBasicFactory() {
            return GlowstoneParticle::new;
        }

        public ParticleType<?> getType() {
            return NorthstarParticles.GLOWSTONE_PARTICLE.get();
        }
    }

    public static class Factory
    implements ParticleProvider<GlowstoneParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(GlowstoneParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GlowstoneParticle(worldIn, x, y, z, zSpeed, zSpeed, zSpeed, this.spriteSet);
        }
    }
}

