/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.ColdAirParticleData;
import com.lightning.northstar.particle.NorthstarParticles;
import com.simibubi.create.content.equipment.bell.BasicParticleData;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class ColdAirParticle
extends SimpleAnimatedParticle {
    protected ColdAirParticle(ClientLevel world, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.random.nextFloat() * 0.1f);
        this.quadSize *= 0.75f;
        this.lifetime = 70;
        this.scale(3.0f);
        this.setSize(0.25f, 0.25f);
        double x_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.01;
        double z_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.01;
        this.xd += x_off;
        this.yd += 0.02;
        this.zd += z_off;
        this.hasPhysics = true;
        this.selectSprite(7);
        Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)world.random, (float)0.15f);
        this.setPos(x + offset.x, y + offset.y - 0.3, z + offset.z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setAlpha(0.6f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private void selectSprite(int index) {
        this.setSprite(this.sprites.get(index, 8));
    }

    public float getQuadSize(float pScaleFactor) {
        float f = ((float)this.age + pScaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f * 0.5f);
    }

    public int getLightColor(float partialTick) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.isLoaded(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockpos) : 0;
    }

    public static class Data
    extends BasicParticleData<ColdAirParticle> {
        public BasicParticleData.IBasicParticleFactory<ColdAirParticle> getBasicFactory() {
            return ColdAirParticle::new;
        }

        public ParticleType<?> getType() {
            return NorthstarParticles.COLD_AIR.get();
        }
    }

    public static class Factory
    implements ParticleProvider<ColdAirParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(ColdAirParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ColdAirParticle(worldIn, x, y, z, zSpeed, zSpeed, zSpeed, this.spriteSet);
        }
    }
}

