/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.compat.jei.category;

import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.contraption.FuelType;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.common.util.RegistryUtil;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.fluids.FluidStack;

public class FuelTypeCategory
extends AbstractRecipeCategory<FuelType> {
    public static final RecipeType<FuelType> RECIPE_TYPE = RecipeType.create((String)"northstar", (String)"fuel_type", FuelType.class);
    private static final int WIDTH = 142;
    private static final int HEIGHT = 110;

    public FuelTypeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)Component.literal((String)"Fuel Type"), guiHelper.createDrawableItemLike(NorthstarBlocks.JET_ENGINE), 142, 110);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FuelType recipe, IFocusGroup focuses) {
        List<FluidStack> fluids = RegistryUtil.getRegistryAccess().registryOrThrow(Registries.FLUID).stream().filter(recipe::supports).map(fluid -> new FluidStack(fluid, 1)).toList();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluids)).setFluidRenderer(1L, false, 16, 16);
    }

    public void draw(FuelType recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, graphics, mouseX, mouseY);
        Font font = Minecraft.getInstance().font;
        graphics.drawString(font, "Combustion engine:", 23, 5, -1);
        graphics.drawString(font, "  Usage: " + recipe.combustionEngineEfficiency() + "mB/t", 23, 15, -1);
        graphics.drawString(font, "  Speed: " + LangNumberFormat.format((double)recipe.combustionEngineRpm()) + " RPM", 23, 25, -1);
        graphics.drawString(font, "Rocket engine:", 23, 35, -1);
        graphics.drawString(font, "  Energy: " + LangNumberFormat.format((double)recipe.gjPerMb()) + "gJ/mB", 23, 45, -1);
    }
}

