/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.solar_panel;

import com.lightning.northstar.block.tech.solar_panel.SolarPanelBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SolarPanelBlock
extends HorizontalKineticBlock
implements IBE<SolarPanelBlockEntity> {
    public static final VoxelShape SHAPE_X = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0);
    public static final VoxelShape SHAPE_Z = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");

    public SolarPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{NORTH, SOUTH}));
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        super.onPlace(state, world, pos, oldState, moved);
        if (!(oldState.getBlock() instanceof SolarPanelBlock)) {
            this.updateConnectivity(world, pos, state, true);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, world, pos, newState, isMoving);
        if (!(newState.getBlock() instanceof SolarPanelBlock)) {
            this.updateConnectivity(world, pos, state, false);
        }
    }

    private void updateConnectivity(Level world, BlockPos pos, BlockState state, boolean added) {
        state = (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.updateConnectivity(world, pos.north(), added, SOUTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.updateConnectivity(world, pos.south(), added, NORTH)));
        if (added) {
            world.setBlock(pos, state, 22);
        }
    }

    private boolean updateConnectivity(Level world, BlockPos pos, boolean added, BooleanProperty prop) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof SolarPanelBlock) {
            world.setBlock(pos, (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(added)), 22);
            return true;
        }
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis() == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getCounterClockWise());
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis() == face.getAxis();
    }

    public float getParticleTargetRadius() {
        return 1.125f;
    }

    public float getParticleInitialRadius() {
        return 1.0f;
    }

    public boolean hideStressImpact() {
        return true;
    }

    public Class<SolarPanelBlockEntity> getBlockEntityClass() {
        return SolarPanelBlockEntity.class;
    }

    public BlockEntityType<? extends SolarPanelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.SOLAR_PANEL.get();
    }
}

