/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_sealer;

import com.lightning.northstar.block.tech.oxygen_sealer.OxygenSealerBlock;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.particle.OxyFlowParticleData;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.NorthstarOxygen;
import com.lightning.northstar.world.SealingProvider;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class OxygenSealerBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
SealingProvider {
    protected final ProgressiveBlockSealer sealer = new ProgressiveBlockSealer();
    protected SmartFluidTankBehaviour oxygenTank;
    protected int sealCooldown;
    protected float drain;
    protected boolean active;
    protected int audioTick;

    public OxygenSealerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.oxygenTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true);
        behaviours.add((BlockEntityBehaviour)this.oxygenTank);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.OXYGEN_SEALER.get(), (be, face) -> {
            if (face == ((Direction)be.getBlockState().getValue(OxygenSealerBlock.HORIZONTAL_FACING)).getOpposite()) {
                return be.oxygenTank.getCapability();
            }
            return null;
        });
    }

    public void initialize() {
        super.initialize();
        this.level.northstar$oxygen().registerSealer(this);
    }

    public void invalidate() {
        super.invalidate();
        this.level.northstar$oxygen().unregisterSealer(this);
    }

    public void tick() {
        super.tick();
        if (this.sealer.isSealInProgress()) {
            if (this.sealer.updateSeal(this.level, this.getMaximumSealedBlocks())) {
                this.sealCooldown = (Integer)NorthstarConfigs.server().sealerCheckDelay.get();
            }
        } else if (this.sealCooldown-- <= 0) {
            this.sealer.beginSeal(this.level, this.worldPosition, Direction.UP);
        }
        if (this.sealer.hasLeak()) {
            this.active = false;
            return;
        }
        FluidStack fluid = this.oxygenTank.getPrimaryHandler().getFluid();
        if (!NorthstarOxygen.isOxygen(fluid.getFluid()) || fluid.isEmpty() || this.isOverStressed() || this.speed == 0.0f) {
            this.active = false;
            return;
        }
        int drainable = Math.min((int)this.drain, fluid.getAmount());
        this.oxygenTank.getPrimaryHandler().drain(drainable, IFluidHandler.FluidAction.EXECUTE);
        this.drain -= (float)drainable;
        boolean bl = this.active = this.drain < 1.0f;
        if (this.active) {
            this.drain += (float)this.sealer.getSealedBlockCount() * NorthstarConfigs.server().oxygenSealerOxygenPerBlockPerTick.getF();
            if (this.level.isClientSide) {
                if (this.audioTick++ % 13 == 0) {
                    this.level.playLocalSound(this.worldPosition, (SoundEvent)NorthstarSounds.AIRFLOW.get(), SoundSource.BLOCKS, 0.1f, 0.0f, false);
                }
                if ((double)this.level.random.nextFloat() < (Double)AllConfigs.client().fanParticleDensity.get()) {
                    this.level.addParticle((ParticleOptions)new OxyFlowParticleData((Vec3i)this.getBlockPos().offset(0, 1, 0)), (double)this.worldPosition.getX() + 0.5, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public boolean isSealed(Vec3 pos) {
        return this.isSealed(Mth.floor((double)pos.x), Mth.floor((double)pos.y), Mth.floor((double)pos.z));
    }

    @Override
    public boolean isSealed(Vec3i pos) {
        return this.isSealed(pos.getX(), pos.getY(), pos.getZ());
    }

    private boolean isSealed(int x, int y, int z) {
        return this.active && this.sealer.getSealedBlocks().contains(BlockPos.asLong((int)x, (int)y, (int)z));
    }

    public int getMaximumSealedBlocks() {
        return (int)((float)((Integer)NorthstarConfigs.server().oxygenSealerBlocksPerRpm.get()).intValue() * Math.abs(this.speed));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToGoggleTooltip(tooltip, isPlayerSneaking)) {
            tooltip.add((Component)Component.empty());
        }
        NorthstarLang.translate("gui.oxygen_sealer", new Object[0]).forGoggles(tooltip);
        this.sealer.addToGoggleTooltip(tooltip, this.getMaximumSealedBlocks());
        if (!this.sealer.hasLeak()) {
            if (this.active) {
                NorthstarLang.translate("gui.oxygen_sealer.oxygen_usage", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
                CreateLang.number((double)((float)this.sealer.getSealedBlockCount() * NorthstarConfigs.server().oxygenSealerOxygenPerBlockPerTick.getF())).style(ChatFormatting.AQUA).add(NorthstarLang.MB_PER_TICK).forGoggles(tooltip, 1);
            } else {
                NorthstarLang.translate("gui.oxygen_sealer.no_oxygen", new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
            }
        }
        if (isPlayerSneaking) {
            this.sealer.addCooldownTooltip(tooltip, this.sealCooldown, this.getMaximumSealedBlocks());
        }
        tooltip.add((Component)Component.empty());
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.oxygenTank.getCapability());
        return true;
    }

    public boolean isActive() {
        return this.active;
    }

    public ProgressiveBlockSealer getSealer() {
        return this.sealer;
    }
}

