/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.world.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class CustomIceBlock
extends HalfTransparentBlock {
    public Fluid fluid;

    public CustomIceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void playerDestroy(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pTe, pStack);
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)pLevel.holderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)pStack) == 0) {
            BlockState below;
            if (pLevel.dimensionType().ultraWarm()) {
                pLevel.removeBlock(pPos, false);
                return;
            }
            if ((float)NorthstarTemperature.getFreezingPoint(this.fluid.defaultFluidState()) > NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos) && ((below = pLevel.getBlockState(pPos.below())).blocksMotion() || below.liquid())) {
                pLevel.setBlockAndUpdate(pPos, this.fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, this.fluid.defaultFluidState()));
            }
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((float)NorthstarTemperature.getBoilingPoint(this.fluid.defaultFluidState()) > NorthstarTemperature.getTemperatureAt((Level)pLevel, (Vec3i)pPos)) {
            this.evaporate(pState, (Level)pLevel, pPos);
        }
        if ((float)NorthstarTemperature.getFreezingPoint(this.fluid.defaultFluidState()) > NorthstarTemperature.getTemperatureAt((Level)pLevel, (Vec3i)pPos)) {
            this.melt(pState, (Level)pLevel, pPos);
        }
    }

    protected void melt(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.setBlockAndUpdate(pPos, this.fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, this.fluid.defaultFluidState()));
        pLevel.neighborChanged(pPos, this.fluid.getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, this.fluid.defaultFluidState()).getBlock(), pPos);
    }

    protected void evaporate(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
        pLevel.neighborChanged(pPos, Blocks.AIR, pPos);
        int i = pPos.getX();
        int j = pPos.getY();
        int k = pPos.getZ();
        pLevel.playSound(null, pPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    @Deprecated
    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.NORMAL;
    }
}

