/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.propeties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.FloatRangeFromStringArrayProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFEntity;

public class EntityVariableFloatProperty
extends RandomProperty {
    private final List<FloatRangeFromStringArrayProperty> VARIABLES;

    protected EntityVariableFloatProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        String keyPrefix = "var." + propertyNum + ".";
        this.VARIABLES = new ArrayList<FloatRangeFromStringArrayProperty>();
        for (Map.Entry<Object, Object> objectObjectEntry : properties.entrySet()) {
            String key = objectObjectEntry.getKey().toString();
            Object value = objectObjectEntry.getValue();
            if (key == null || !key.startsWith(keyPrefix)) continue;
            String instruction = ((String)value).trim();
            String variableKey = "var." + key.replaceAll(keyPrefix, "");
            if (variableKey.isBlank() || instruction.isBlank()) continue;
            InnerTester tester = new InnerTester(instruction, emfEntity -> Float.valueOf(emfEntity.emf$getVariableMap().getFloat((Object)variableKey)), variableKey);
            this.VARIABLES.add(tester);
        }
        if (this.VARIABLES.isEmpty()) {
            throw new RandomProperty.RandomPropertyException("Variable float failed");
        }
    }

    public static EntityVariableFloatProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new EntityVariableFloatProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException var3) {
            return null;
        }
    }

    protected boolean testEntityInternal(ETFEntityRenderState etfEntity) {
        for (FloatRangeFromStringArrayProperty variable : this.VARIABLES) {
            if (variable.testEntityInternal(etfEntity)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"var"};
    }

    protected String getPrintableRuleInfo() {
        return null;
    }

    private static class InnerTester
    extends FloatRangeFromStringArrayProperty {
        private final Function<EMFEntity, Float> getter;
        private final String id;

        protected InnerTester(String string, Function<EMFEntity, Float> getter, String id) throws RandomProperty.RandomPropertyException {
            super(string);
            this.getter = getter;
            this.id = id;
        }

        @Nullable
        protected Float getRangeValueFromEntity(ETFEntityRenderState etfEntity) {
            ETFEntity eTFEntity;
            if (etfEntity != null && (eTFEntity = etfEntity.entity()) instanceof EMFEntity) {
                EMFEntity IEMFEntity = (EMFEntity)eTFEntity;
                return this.getter.apply(IEMFEntity);
            }
            return null;
        }

        @NotNull
        public String[] getPropertyIds() {
            return new String[]{this.id};
        }
    }
}

