/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin.mixins.rendering.arrows;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPartRoot;

@Mixin(value={StuckInBodyLayer.class})
public abstract class MixinStuckArrowsFeatureRenderer<T extends LivingEntity, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    public MixinStuckArrowsFeatureRenderer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    @Shadow
    protected abstract int numStuck(T var1);

    @Shadow
    protected abstract void renderStuckItem(PoseStack var1, MultiBufferSource var2, int var3, Entity var4, float var5, float var6, float var7, float var8);

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void emf$start(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        EMFAnimationEntityContext.is_in_ground_override = true;
        if (((IEMFModel)this.getParentModel()).emf$isEMFModel()) {
            ci.cancel();
            EMFModelPartRoot root = ((IEMFModel)this.getParentModel()).emf$getEMFRootModel();
            int i = this.numStuck(livingEntity);
            RandomSource randomSource = RandomSource.create((long)livingEntity.getId());
            if (i > 0) {
                for (int j = 0; j < i; ++j) {
                    Random partRand = new Random(j);
                    poseStack.pushPose();
                    Pair<ModelPart, Runnable> modelPart = this.emf$bestFromListMutable(new ArrayList<ModelPart>(root.getAllVanillaPartsEMF()), partRand, poseStack, true);
                    if (modelPart == null) {
                        EMFAnimationEntityContext.is_in_ground_override = false;
                        poseStack.popPose();
                        return;
                    }
                    ((Runnable)modelPart.getSecond()).run();
                    float f = randomSource.nextFloat();
                    float g = randomSource.nextFloat();
                    float h = randomSource.nextFloat();
                    if (!((ModelPart)modelPart.getFirst()).cubes.isEmpty()) {
                        ModelPart.Cube cube = ((ModelPart)modelPart.getFirst()).getRandomCube(randomSource);
                        float k = Mth.lerp((float)f, (float)cube.minX, (float)cube.maxX) / 16.0f;
                        float l = Mth.lerp((float)g, (float)cube.minY, (float)cube.maxY) / 16.0f;
                        float m = Mth.lerp((float)h, (float)cube.minZ, (float)cube.maxZ) / 16.0f;
                        poseStack.translate(k, l, m);
                    }
                    f = -1.0f * (f * 2.0f - 1.0f);
                    g = -1.0f * (g * 2.0f - 1.0f);
                    h = -1.0f * (h * 2.0f - 1.0f);
                    this.renderStuckItem(poseStack, buffer, packedLight, (Entity)livingEntity, f, g, h, partialTicks);
                    poseStack.popPose();
                }
            }
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="RETURN")})
    private void emf$end(CallbackInfo ci) {
        EMFAnimationEntityContext.is_in_ground_override = false;
    }

    @Unique
    @Nullable
    private Pair<ModelPart, Runnable> emf$bestFromListMutable(List<ModelPart> partsMutable, Random randomSource, PoseStack poseStack, boolean firstIteration) {
        Collections.shuffle(partsMutable, randomSource);
        for (ModelPart modelPart : partsMutable) {
            Pair<ModelPart, Runnable> child;
            if (!modelPart.visible) continue;
            if (!modelPart.cubes.isEmpty() && !modelPart.skipDraw) {
                return Pair.of((Object)modelPart, () -> modelPart.translateAndRotate(poseStack));
            }
            if (modelPart.children.isEmpty() || (child = this.emf$bestFromListMutable(new ArrayList<ModelPart>(modelPart.children.values()), randomSource, poseStack, false)) == null) continue;
            Runnable runnable = (Runnable)child.getSecond();
            return Pair.of((Object)((ModelPart)child.getFirst()), () -> {
                modelPart.translateAndRotate(poseStack);
                runnable.run();
            });
        }
        if (firstIteration && !partsMutable.isEmpty()) {
            ModelPart part = partsMutable.get(0);
            return Pair.of((Object)part, () -> part.translateAndRotate(poseStack));
        }
        return null;
    }
}

