/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.registry.ModLootFunctions;

public class SmeltMatchingItemFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SmeltMatchingItemFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SmeltMatchingItemFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(SmeltMatchingItemFunction::item)).apply((Applicative)instance, SmeltMatchingItemFunction::new));
    private final Holder<Item> item;

    public SmeltMatchingItemFunction(List<LootItemCondition> conditions, Holder<Item> item) {
        super(conditions);
        this.item = item;
    }

    private Holder<Item> item() {
        return this.item;
    }

    public LootItemFunctionType<SmeltMatchingItemFunction> getType() {
        return (LootItemFunctionType)ModLootFunctions.SMELT_MATCHING_ITEM.get();
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (!stack.isEmpty() && stack.getItem() == this.item.value()) {
            ItemStack smelted;
            Optional optional = context.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), (Level)context.getLevel());
            if (optional.isPresent() && !(smelted = ((SmeltingRecipe)((RecipeHolder)optional.get()).value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)).isEmpty()) {
                ItemStack result = smelted.copy();
                result.setCount(stack.getCount() * smelted.getCount());
                return result;
            }
            SomeAssemblyRequired.LOGGER.warn("Couldn't smelt {} because there is no smelting recipe", (Object)stack);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> smeltMatching(Holder<Item> item) {
        return SmeltMatchingItemFunction.simpleBuilder(conditions -> new SmeltMatchingItemFunction((List<LootItemCondition>)conditions, item));
    }
}

