/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public abstract class SandwichRecipeGenerator<RECIPE>
implements ISimpleRecipeManagerPlugin<RECIPE> {
    protected abstract int getMaxToppings();

    public boolean isHandledInput(ITypedIngredient<?> input) {
        if (input.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack item = input.getItemStack().orElse(ItemStack.EMPTY);
            return item.is(ModTags.SANDWICH_BREAD) || this.isHandledFilling(item);
        }
        if (input.getType() == NeoForgeTypes.FLUID_STACK) {
            return this.isHandledFilling((FluidStack)input.getCastIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK));
        }
        return false;
    }

    protected boolean isHandledFilling(ItemStack filling) {
        return !filling.is(ModItems.SANDWICH) && !filling.is(ModTags.SANDWICH_BREAD) && this.getFluidFromFilling(filling).isEmpty() && Ingredients.canAddToSandwich(filling);
    }

    protected boolean isHandledFilling(FluidStack fluid) {
        return this.getFillingFromFluid(fluid).isPresent();
    }

    public boolean isHandledOutput(ITypedIngredient<?> output) {
        if (output.getType() == VanillaTypes.ITEM_STACK) {
            ItemStack stack = output.getItemStack().orElse(ItemStack.EMPTY);
            return stack.is(ModItems.SANDWICH) && SandwichContents.get(stack).size() >= 2;
        }
        return false;
    }

    public List<RECIPE> getRecipesForInput(ITypedIngredient<?> input) {
        if (input.getType() == NeoForgeTypes.FLUID_STACK) {
            Optional<ItemStack> filling = this.getFillingFromFluid((FluidStack)input.getCastIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK));
            if (filling.isEmpty()) {
                return List.of();
            }
            return this.getRecipesForFilling(filling.get());
        }
        ItemStack stack = (ItemStack)input.getItemStack().orElseThrow();
        if ((stack = stack.copyWithCount(1)).is(ModTags.SANDWICH_BREAD)) {
            ItemStack bottomBread = stack.is(ModItems.BURGER_BUN_TOP) ? new ItemStack(ModItems.BURGER_BUN_BOTTOM) : stack;
            ItemStack topBread = stack.is(ModItems.BURGER_BUN_BOTTOM) ? new ItemStack(ModItems.BURGER_BUN_TOP) : stack;
            return this.getRecipesForBread(bottomBread, topBread);
        }
        return this.getRecipesForFilling(stack);
    }

    protected List<RECIPE> getRecipesForBread(ItemStack bottomBread, ItemStack topBread) {
        ArrayList<RECIPE> recipes = new ArrayList<RECIPE>();
        Consumer<ItemStack> consumer = sandwich -> {
            SandwichContents contents = SandwichContents.get(sandwich);
            if (((ItemStack)contents.getFirst()).is(bottomBread.getItem()) && ((ItemStack)contents.getLast()).is(topBread.getItem())) {
                recipes.add(this.getRecipeForSandwich(contents));
            }
        };
        ModCompat.gatherCreativeTabSandwiches(consumer);
        recipes.add(this.createRecipe(bottomBread, new ItemStack((ItemLike)Items.HONEY_BOTTLE), topBread));
        return recipes;
    }

    protected List<RECIPE> getRecipesForFilling(ItemStack filling) {
        ArrayList recipes = new ArrayList();
        BuiltInRegistries.ITEM.getTag(ModTags.SANDWICH_BREAD).ifPresent(tag -> {
            for (Holder holder : tag) {
                if (holder.is(ModTags.BURGER_BUNS)) continue;
                ItemStack bread = new ItemStack((ItemLike)holder.value());
                recipes.add(this.createRecipe(bread, filling, bread));
            }
            ItemStack bottom = new ItemStack(ModItems.BURGER_BUN_BOTTOM);
            ItemStack top = new ItemStack(ModItems.BURGER_BUN_TOP);
            recipes.add(this.createRecipe(bottom, filling, top));
        });
        return recipes;
    }

    protected abstract Optional<ItemStack> getFillingFromFluid(FluidStack var1);

    protected abstract Optional<SizedFluidIngredient> getFluidFromFilling(ItemStack var1);

    protected RECIPE createRecipe(ItemStack bottomBread, ItemStack filling, ItemStack topBread) {
        if (filling.getCount() != 1) {
            filling = filling.copy();
            filling.setCount(1);
        }
        return this.getRecipeForSandwich(new SandwichContents(List.of(bottomBread, filling, topBread)));
    }

    public List<RECIPE> getRecipesForOutput(ITypedIngredient<?> output) {
        ItemStack sandwich = output.getItemStack().orElse(ItemStack.EMPTY);
        return List.of(this.getRecipeForSandwich(SandwichContents.get(sandwich)));
    }

    protected RECIPE getRecipeForSandwich(SandwichContents contents) {
        List<ItemStack> items = contents;
        ItemStack prefix = (ItemStack)items.getFirst();
        int size = items.size();
        if (size - 1 > this.getMaxToppings()) {
            prefix = SandwichItem.of(items.subList(0, size - this.getMaxToppings()));
            items = items.subList(size - this.getMaxToppings(), size);
        } else {
            items = items.subList(1, size);
        }
        return this.getRecipeForSandwich(prefix, items, contents.makeItem());
    }

    protected abstract RECIPE getRecipeForSandwich(ItemStack var1, List<ItemStack> var2, ItemStack var3);

    public List<RECIPE> getAllRecipes() {
        ArrayList<RECIPE> recipes = new ArrayList<RECIPE>();
        ModCompat.gatherCreativeTabSandwiches(sandwich -> recipes.add(this.getRecipeForSandwich(SandwichContents.get(sandwich))));
        recipes.add(this.getRecipeForSandwich(SandwichContents.get(SandwichItem.makeToastSandwich(new ItemLike[]{Items.HONEY_BOTTLE}))));
        return recipes;
    }
}

