/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IExtraIngredientRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.integration.jei.SandwichingStationCategory;
import someassemblyrequired.integration.jei.SandwichingStationRecipeGenerator;
import someassemblyrequired.integration.jei.create.SequencedAssemblyRecipeGenerator;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.registry.ModBlocks;
import someassemblyrequired.registry.ModItems;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = SomeAssemblyRequired.id("main");
    public static final RecipeType<SandwichingStationCategory.Recipe> SANDWICHING_STATION = RecipeType.create((String)"someassemblyrequired", (String)"sandwiching_station", SandwichingStationCategory.Recipe.class);

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        ArrayList<ItemStack> sandwiches = new ArrayList<ItemStack>();
        ModCompat.gatherCreativeTabSandwiches(sandwiches::add);
        ModCompat.gatherJEISandwiches(sandwiches::add);
        sandwiches.removeIf(sandwich -> !SandwichContents.get(sandwich).isBurger());
        registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, sandwiches, ((SandwichItem)((Object)ModItems.SANDWICH.get())).getDescriptionId());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addIngredientInfo((ItemLike)ModItems.SANDWICHING_STATION.get(), new Component[]{SomeAssemblyRequired.translate("sandwiching_station.info.creating_sandwiches.1", new Object[0]), SomeAssemblyRequired.translate("sandwiching_station.info.creating_sandwiches.2", new Object[0]), SomeAssemblyRequired.translate("sandwiching_station.info.creating_sandwiches.3", new Object[0]), SomeAssemblyRequired.translate("sandwiching_station.info.creating_sandwiches.4", new Object[0])});
        registration.addIngredientInfo((ItemLike)ModItems.SANDWICHING_STATION.get(), new Component[]{SomeAssemblyRequired.translate("sandwiching_station.info.bonus_effects.1", new Object[0]), SomeAssemblyRequired.translate("sandwiching_station.info.bonus_effects.2", this.getMinIngredients((List)ModConfig.server.sandwichEffectDurations.get()), Component.translatable((String)ModConfig.server.getSandwichBonusEffect(false).map(holder -> ((MobEffect)holder.value()).getDescriptionId()).orElse("unknown")), this.getMinIngredients((List)ModConfig.server.burgerEffectDurations.get()), Component.translatable((String)ModConfig.server.getSandwichBonusEffect(true).map(holder -> ((MobEffect)holder.value()).getDescriptionId()).orElse("unknown"))), SomeAssemblyRequired.translate("sandwiching_station.info.bonus_effects.3", new Object[0])});
    }

    private int getMinIngredients(List<Integer> durations) {
        for (int i = 0; i < durations.size(); ++i) {
            if (durations.get(i) <= 0) continue;
            return i;
        }
        return 0;
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        if (ModCompat.isCreateLoaded()) {
            SequencedAssemblyRecipeGenerator.register(registration);
        }
        registration.addTypedRecipeManagerPlugin(SANDWICHING_STATION, (ISimpleRecipeManagerPlugin)new SandwichingStationRecipeGenerator());
    }

    public void registerExtraIngredients(IExtraIngredientRegistration registration) {
        ArrayList<ItemStack> sandwiches = new ArrayList<ItemStack>();
        ModCompat.gatherJEISandwiches(sandwiches::add);
        sandwiches.sort(Comparator.comparingInt(stack -> -BuiltInRegistries.ITEM.getId((Object)((ItemStack)SandwichContents.get(stack).getFirst()).getItem())));
        registration.addExtraItemStacks(sandwiches);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SandwichingStationCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.SANDWICH.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return SandwichContents.get(ingredient);
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return this.getSubtypeData(ingredient, context).toString();
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SANDWICHING_STATION.get()), new RecipeType[]{SANDWICHING_STATION});
    }
}

