/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers.ingredient;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import someassemblyrequired.ingredient.IngredientProperties;
import someassemblyrequired.registry.ModDataComponents;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModSoundEvents;

public class IngredientBuilder {
    private final Holder<Item> item;
    @Nullable
    private Component displayName;
    @Nullable
    private Component fullName;
    @Nullable
    private SoundEvent soundEvent;
    private ItemStack displayItem = ItemStack.EMPTY;
    private int height = 1;
    private boolean renderAsItem = true;
    private FoodProperties foodProperties = null;
    private boolean hidden = false;

    public IngredientBuilder(Holder<Item> item) {
        this.item = item;
    }

    public IngredientProperties build() {
        return new IngredientProperties(this.item, Optional.ofNullable(this.foodProperties), Optional.ofNullable(this.displayName), Optional.ofNullable(this.fullName), this.displayItem, (Holder<SoundEvent>)(this.soundEvent == null ? ModSoundEvents.ADD_ITEM : BuiltInRegistries.SOUND_EVENT.getHolderOrThrow((ResourceKey)BuiltInRegistries.SOUND_EVENT.getResourceKey((Object)this.soundEvent).orElseThrow())), this.height, this.renderAsItem, this.hidden);
    }

    public Holder<Item> getItem() {
        return this.item;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public IngredientBuilder setDisplayName(Component displayName) {
        this.displayName = displayName;
        return this;
    }

    public IngredientBuilder setDisplayName(String translationKey) {
        return this.setDisplayName((Component)Component.translatable((String)translationKey));
    }

    public IngredientBuilder setDisplayName(Holder<Item> item) {
        return this.setDisplayName(IngredientBuilder.getDefaultTranslationKey(item));
    }

    public IngredientBuilder setCustomDisplayName() {
        return this.setDisplayName(this.getItem());
    }

    public IngredientBuilder setFullName(Component fullName) {
        this.fullName = fullName;
        return this;
    }

    public IngredientBuilder setFullName(String translationKey) {
        return this.setFullName((Component)Component.translatable((String)translationKey));
    }

    public IngredientBuilder setFullName(Holder<Item> item) {
        return this.setFullName(IngredientBuilder.getDefaultTranslationKey(item));
    }

    public IngredientBuilder setCustomFullName() {
        return this.setFullName(IngredientBuilder.getDefaultTranslationKey(this.getItem()));
    }

    public IngredientBuilder setDisplayItem(ItemStack displayItem) {
        this.displayItem = displayItem;
        return this;
    }

    public IngredientBuilder setSpread(int color) {
        return this.setSpread(color, 1.0);
    }

    public IngredientBuilder setSpread(int color, double alpha) {
        ItemStack spread = new ItemStack((ItemLike)ModItems.SPREAD.get());
        int a = (int)(alpha * 255.0);
        spread.set(ModDataComponents.SPREAD_COLOR, (Object)(color & 0xFFFFFF | a << 24));
        return this.setDisplayItem(spread);
    }

    public IngredientBuilder setWetSound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_WET.get());
    }

    public IngredientBuilder setMoistSound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_MOIST.get());
    }

    public IngredientBuilder setSlimySound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_SLIMY.get());
    }

    public IngredientBuilder setLeafySound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_LEAFY.get());
    }

    public IngredientBuilder setSound(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    public IngredientBuilder setHeight(int height) {
        this.height = height;
        return this;
    }

    public IngredientBuilder customModel() {
        this.renderAsItem = false;
        return this;
    }

    public IngredientBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public IngredientBuilder setFoodProperties(FoodProperties foodProperties) {
        this.foodProperties = foodProperties;
        return this;
    }

    private static String getDefaultTranslationKey(Holder<Item> item) {
        ResourceLocation id = Objects.requireNonNull(item.getKey()).location();
        if ("minecraft".equals(id.getNamespace()) || "someassemblyrequired".equals(id.getNamespace())) {
            return "%s.ingredient.%s".formatted("someassemblyrequired", id.getPath());
        }
        return "%s.ingredient.%s.%s".formatted("someassemblyrequired", id.getNamespace(), id.getPath());
    }
}

