/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.data.providers.recipe.SandwichSpoutingRecipeBuilder;
import someassemblyrequired.data.providers.recipe.create.CuttingRecipeGenerator;
import someassemblyrequired.data.providers.recipe.create.PressingRecipeGenerator;
import someassemblyrequired.data.providers.recipe.farmersdelight.CuttingRecipes;
import someassemblyrequired.registry.ModBlocks;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class Recipes
extends RecipeProvider {
    static final List<ProcessingRecipeGen<?, ?, ?>> GENERATORS = new ArrayList();

    public Recipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.addCraftingRecipes(output);
        this.addCookingRecipes(output);
        CuttingRecipes.addCuttingRecipes(output);
        SandwichSpoutingRecipeBuilder.addFillingRecipes(output);
    }

    public static void registerAllProcessing(DataGenerator gen, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new CuttingRecipeGenerator(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new PressingRecipeGenerator(output, registries));
        gen.addProvider(true, new DataProvider(){

            public String getName() {
                return "Processing Recipes";
            }

            public CompletableFuture<?> run(CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.run(dc)).toArray(CompletableFuture[]::new));
            }
        });
    }

    private void addCraftingRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ModBlocks.SANDWICHING_STATION.get())).pattern("AA").pattern("BB").define(Character.valueOf('A'), (ItemLike)Items.SMOOTH_STONE).define(Character.valueOf('B'), ItemTags.PLANKS).unlockedBy("has_smooth_stone", this.createItemCriterion((ItemLike)Items.SMOOTH_STONE)).save(output, this.getRecipeLocation((ItemLike)ModBlocks.SANDWICHING_STATION.get(), "crafting_shaped"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.RAW_BURGER_BUN.get())).requires(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(ModTags.DOUGH), new Ingredient.TagValue(ModTags.DOUGHS)))).requires(Ingredient.of((TagKey)Tags.Items.SEEDS)).unlockedBy("has_seeds", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(Tags.Items.SEEDS)})).save(output, this.getRecipeLocation((ItemLike)ModItems.RAW_BURGER_BUN.get(), "crafting_shapeless"));
    }

    private void addCookingRecipes(RecipeOutput output) {
        this.addCookingRecipes(output, 200, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, "smelting");
        this.addCookingRecipes(output, 100, RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, "smoking");
        this.addCookingRecipes(output, 600, RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, "campfire_cooking");
    }

    private <T extends AbstractCookingRecipe> void addCookingRecipes(RecipeOutput output, int time, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, String type) {
        this.addCookingRecipe((Supplier<Item>)ModItems.BREAD_SLICE, (Supplier<Item>)ModItems.TOASTED_BREAD_SLICE, output, time, serializer, factory, type);
        this.addCookingRecipe((Supplier<Item>)ModItems.RAW_BURGER_BUN, (Supplier<Item>)ModItems.BURGER_BUN, output, time, serializer, factory, type);
    }

    private <T extends AbstractCookingRecipe> void addCookingRecipe(Supplier<Item> input, Supplier<Item> result, RecipeOutput output, int time, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, String type) {
        SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)result.get()), (float)0.35f, (int)time, serializer, factory).unlockedBy("has_ingredient", this.createItemCriterion((ItemLike)input.get())).save(output, this.getRecipeLocation((ItemLike)result.get(), type));
    }

    private ResourceLocation getRecipeLocation(ItemLike result, String location) {
        return SomeAssemblyRequired.id(location + "/" + BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath());
    }

    private Criterion<InventoryChangeTrigger.TriggerInstance> createItemCriterion(ItemLike itemProvider) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{itemProvider});
    }
}

