/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import com.google.common.base.Preconditions;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.data.providers.LootModifiers;
import someassemblyrequired.loot.OptionalLootItem;
import someassemblyrequired.loot.SetSandwichContentsFunction;
import someassemblyrequired.loot.SmeltMatchingItemFunction;
import someassemblyrequired.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;

public class LootTables
extends LootTableProvider {
    private final List<LootTableProvider.SubProviderEntry> lootTables = new ArrayList<LootTableProvider.SubProviderEntry>();
    private final ExistingFileHelper existingFileHelper;
    private final LootModifiers lootModifiers;
    protected static final ResourceKey<LootTable> VILLAGE_SANDWICH = SomeAssemblyRequired.key(Registries.LOOT_TABLE, "inject/chests/village_house");

    public LootTables(PackOutput packOutput, ExistingFileHelper existingFileHelper, LootModifiers lootModifiers, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, Set.of(), List.of(), registries);
        this.existingFileHelper = existingFileHelper;
        this.lootModifiers = lootModifiers;
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        this.lootTables.clear();
        this.addStandardDropTable((Block)ModBlocks.SANDWICHING_STATION.get());
        this.addSandwichLootTables();
        for (LootModifiers.Builder lootBuilder : this.lootModifiers.lootBuilders) {
            this.addLootTable(lootBuilder.getName(), lootBuilder.createLootTable(), lootBuilder.getParameterSet());
        }
        return this.lootTables;
    }

    private void addSandwichLootTables() {
        ResourceKey sandwich = SomeAssemblyRequired.key(Registries.LOOT_TABLE, "sandwich/sandwich");
        ResourceKey sandwichLayer = SomeAssemblyRequired.key(Registries.LOOT_TABLE, "sandwich/sandwich_layer");
        ResourceKey special = SomeAssemblyRequired.key(Registries.LOOT_TABLE, "sandwich/special");
        ResourceKey burger = SomeAssemblyRequired.key(Registries.LOOT_TABLE, "sandwich/burger");
        ResourceKey protein = SomeAssemblyRequired.key(Registries.LOOT_TABLE, "sandwich/ingredients/protein");
        ResourceKey vegetables = SomeAssemblyRequired.key(Registries.LOOT_TABLE, "sandwich/ingredients/vegetables");
        this.addLootTable(protein.location().getPath(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootTables.whenNotLoaded(Items.COOKED_BEEF, 1, "farmersdelight")).add(LootTables.whenNotLoaded(Items.COOKED_PORKCHOP, 1, "farmersdelight")).add(LootTables.whenNotLoaded(Items.COOKED_SALMON, 1, "farmersdelight")).add(LootTables.whenNotLoaded(Items.COOKED_COD, 1, "farmersdelight")).add(LootTables.whenLoaded((Item)ModItems.COOKED_BACON.get(), 3)).add(LootTables.whenLoaded((Item)ModItems.FRIED_EGG.get(), 4)).add(LootTables.whenLoaded((Item)ModItems.COOKED_CHICKEN_CUTS.get(), 3)).add(LootTables.whenLoaded((Item)ModItems.COOKED_MUTTON_CHOPS.get(), 2)).add(LootTables.whenLoaded((Item)ModItems.COOKED_COD_SLICE.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.COOKED_SALMON_SLICE.get(), 1))), LootContextParamSets.CHEST);
        this.addLootTable(vegetables.location().getPath(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootTables.item(Items.SWEET_BERRIES, 1)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_CARROT.get(), 3)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_GOLDEN_CARROT.get(), 1)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.APPLE_SLICES.get(), 2)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.GOLDEN_APPLE_SLICES.get(), 1)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_BEETROOT.get(), 3)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.TOMATO_SLICES.get(), 4)).add(LootTables.whenLoaded((Item)ModItems.CABBAGE_LEAF.get(), 4))), LootContextParamSets.CHEST);
        this.addLootTable(sandwichLayer.location().getPath(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{NestedLootTable.lootTableReference(protein).when(LootTables.chance(0.7))}).otherwise((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(vegetables)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(vegetables))), LootContextParamSets.CHEST);
        this.addLootTable(sandwich.location().getPath(), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(sandwichLayer))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(sandwichLayer)).when(LootTables.chance(0.1))).withPool(LootPool.lootPool().add(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))), LootContextParamSets.CHEST);
        this.addLootTable(special.location().getPath(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))).withPool(LootPool.lootPool().add(LootTables.item(Items.HONEY_BOTTLE, 15)).add(LootTables.item(((BaseFlowingFluid.Flowing)AllFluids.CHOCOLATE.get()).getBucket(), 15)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.TOASTED_BREAD_SLICE.get(), 1)).add(LootTables.item(Items.MILK_BUCKET, 1)).add(LootTables.item(Items.POTATO, 1)).add(LootTables.whenLoaded((Item)ModItems.SQUID_INK_PASTA.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.EGG_SANDWICH.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.HOT_COCOA.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.PUMPKIN_SOUP.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.PASTA_WITH_MEATBALLS.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.RATATOUILLE.get(), 1)).add(LootTables.whenLoaded((Item)AllItems.BUILDERS_TEA.get(), 1)).add(LootTables.whenLoaded((Item)AllItems.CHOCOLATE_BERRIES.get(), 1))).withPool(LootPool.lootPool().add(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))), LootContextParamSets.CHEST);
        this.addLootTable(burger.location().getPath(), LootTable.lootTable().withPool(LootPool.lootPool().add(LootTables.item((Item)someassemblyrequired.registry.ModItems.BURGER_BUN_BOTTOM.get()))).withPool(LootPool.lootPool().add(LootTables.whenLoaded((Item)ModItems.BEEF_PATTY.get(), 5)).add(LootTables.whenLoaded((Item)ModItems.COOKED_BACON.get(), 2)).add(LootTables.whenLoaded((Item)ModItems.COOKED_MUTTON_CHOPS.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.FRIED_EGG.get(), 2)).add(LootTables.whenNotLoaded(Items.COOKED_BEEF, 1, "farmersdelight")).add(LootTables.whenNotLoaded(Items.COOKED_PORKCHOP, 1, "farmersdelight"))).withPool(LootPool.lootPool().when(LootTables.chance(0.2)).add(LootTables.whenLoaded((Item)ModItems.COOKED_BACON.get(), 1)).add(LootTables.whenLoaded((Item)ModItems.TOMATO_SAUCE.get(), 1))).withPool(LootPool.lootPool().when(LootTables.chance(0.5)).add(LootTables.whenLoaded((Item)ModItems.CABBAGE_LEAF.get(), 1))).withPool(LootPool.lootPool().when(LootTables.chance(0.5)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.TOMATO_SLICES.get()))).withPool(LootPool.lootPool().when(LootTables.chance(0.6)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.SLICED_ONION.get()))).withPool(LootPool.lootPool().when(LootTables.chance(0.2)).add(LootTables.item(Items.SWEET_BERRIES, 1)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_CARROT.get(), 3)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_GOLDEN_CARROT.get(), 1)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.APPLE_SLICES.get(), 2)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.GOLDEN_APPLE_SLICES.get(), 1)).add(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_BEETROOT.get(), 3))).withPool(LootPool.lootPool().add(LootTables.item((Item)someassemblyrequired.registry.ModItems.BURGER_BUN_TOP.get()))), LootContextParamSets.CHEST);
        this.addLootTableUnchecked(VILLAGE_SANDWICH.location().getPath(), LootTable.lootTable().withPool(LootPool.lootPool().when(LootTables.chance(0.4)).add((LootPoolEntryContainer.Builder)LootTables.sandwich().setWeight(4).apply(LootTables.count(2, 5)).apply((LootItemFunction.Builder)SetSandwichContentsFunction.setIngredients().withEntry((LootPoolEntryContainer.Builder<?>)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{NestedLootTable.lootTableReference(special).when(LootTables.chance(0.15)), ((LootPoolSingletonContainer.Builder)NestedLootTable.lootTableReference(sandwich).when(LootTables.chance(0.25))).apply(LootTables.toastBread())}).otherwise((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(sandwich))))).add((LootPoolEntryContainer.Builder)LootTables.sandwich().apply(LootTables.count(2, 5)).apply((LootItemFunction.Builder)SetSandwichContentsFunction.setIngredients().withEntry((LootPoolEntryContainer.Builder<?>)NestedLootTable.lootTableReference(burger))))), LootContextParamSets.CHEST);
    }

    private void addStandardDropTable(Block block) {
        this.addBlockLootTable(block, LootTable.lootTable().withPool(this.createStandardDrops((ItemLike)block)));
    }

    private void addBlockLootTable(Block block, LootTable.Builder lootTable) {
        this.lootTables.add(new LootTableProvider.SubProviderEntry(registries -> lootBuilder -> lootBuilder.accept(block.getLootTable(), lootTable), LootContextParamSets.BLOCK));
    }

    private LootPool.Builder createStandardDrops(ItemLike itemProvider) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(ExplosionCondition.survivesExplosion()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemProvider));
    }

    protected static LootItemConditionalFunction.Builder<?> toastBread() {
        return SmeltMatchingItemFunction.smeltMatching(someassemblyrequired.registry.ModItems.BREAD_SLICE);
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich(Holder<Potion> potion) {
        return LootTables.sandwich(LootTables.potion(potion));
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich(Item item) {
        return LootTables.sandwich(LootTables.item(item));
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich(LootPoolSingletonContainer.Builder<?> ingredient) {
        return LootTables.sandwich().apply((LootItemFunction.Builder)SetSandwichContentsFunction.setIngredients().withEntry((LootPoolEntryContainer.Builder<?>)LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get())).withEntry((LootPoolEntryContainer.Builder<?>)ingredient).withEntry((LootPoolEntryContainer.Builder<?>)LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get())));
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich() {
        return LootTables.item((Item)someassemblyrequired.registry.ModItems.SANDWICH.get());
    }

    protected static LootPoolSingletonContainer.Builder<?> potion(Holder<Potion> potion) {
        return LootTables.item(Items.POTION).apply((LootItemFunction.Builder)SetPotionFunction.setPotion(potion));
    }

    protected static LootPoolSingletonContainer.Builder<?> whenLoaded(Item item, int weight) {
        return OptionalLootItem.whenLoaded(item).setWeight(weight);
    }

    protected static LootPoolSingletonContainer.Builder<?> whenNotLoaded(Item item, int weight, String modid) {
        return OptionalLootItem.optionalLootItem(BuiltInRegistries.ITEM.getKey((Object)item), new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition(modid))}).setWeight(weight);
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item) {
        return LootTables.item(item, 1);
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item, int weight) {
        return LootItem.lootTableItem((ItemLike)item).setWeight(weight);
    }

    protected static LootItemConditionalFunction.Builder<?> count(int min, int max) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    protected static LootItemCondition.Builder chance(double chance) {
        return LootItemRandomChanceCondition.randomChance((float)((float)chance));
    }

    private void addLootTable(String location, LootTable.Builder lootTable, LootContextParamSet lootParameterSet) {
        if (location.startsWith("inject/")) {
            String actualLocation = location.replace("inject/", "");
            Preconditions.checkArgument((boolean)this.existingFileHelper.exists(ResourceLocation.parse((String)("loot_table/" + actualLocation + ".json")), PackType.SERVER_DATA), (String)"Loot table %s does not exist in any known data pack", (Object)actualLocation);
        }
        this.lootTables.add(new LootTableProvider.SubProviderEntry(registries -> lootBuilder -> lootBuilder.accept(SomeAssemblyRequired.key(Registries.LOOT_TABLE, location), lootTable), lootParameterSet));
    }

    private void addLootTableUnchecked(String location, LootTable.Builder lootTable, LootContextParamSet lootParameterSet) {
        this.lootTables.add(new LootTableProvider.SubProviderEntry(registries -> lootBuilder -> lootBuilder.accept(SomeAssemblyRequired.key(Registries.LOOT_TABLE, location), lootTable), lootParameterSet));
    }
}

