/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.registry;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.davio.aquaticambitions.CreateAquaticAmbitions;
import net.davio.aquaticambitions.content.kinetics.fan.processing.ChannelingRecipe;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public enum CAARecipeTypes implements IRecipeTypeInfo,
StringRepresentable
{
    CHANNELING(ChannelingRecipe::new);

    public static final Predicate<RecipeHolder<?>> CAN_BE_AUTOMATED;
    public final ResourceLocation id;
    public final Supplier<RecipeSerializer<?>> serializerSupplier;
    public final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> serializerObject;
    public final Supplier<RecipeType<?>> type;
    public static final Codec<CAARecipeTypes> CODEC;
    private boolean isProcessingRecipe;

    private CAARecipeTypes(Supplier<RecipeSerializer<?>> serializerSupplier) {
        DeferredHolder typeObject;
        String name = Lang.asId((String)this.name());
        this.id = CreateAquaticAmbitions.asResource(name);
        this.serializerObject = Registers.SERIALIZER_REGISTER.register(name, serializerSupplier);
        this.type = typeObject = Registers.TYPE_REGISTER.register(name, () -> RecipeType.simple((ResourceLocation)this.id));
        this.serializerSupplier = serializerSupplier;
        this.isProcessingRecipe = false;
    }

    private CAARecipeTypes(StandardProcessingRecipe.Factory<?> processingFactory) {
        this(() -> new StandardProcessingRecipe.Serializer(processingFactory));
        this.isProcessingRecipe = true;
    }

    public static void register(IEventBus modEventBus) {
        ShapedRecipePattern.setCraftingSize((int)9, (int)9);
        Registers.SERIALIZER_REGISTER.register(modEventBus);
        Registers.TYPE_REGISTER.register(modEventBus);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public <T extends RecipeSerializer<?>> T getSerializer() {
        return (T)((RecipeSerializer)this.serializerObject.get());
    }

    public <I extends RecipeInput, R extends Recipe<I>> RecipeType<R> getType() {
        return this.type.get();
    }

    public <I extends RecipeInput, R extends Recipe<I>> Optional<RecipeHolder<R>> find(I inv, Level world) {
        return world.getRecipeManager().getRecipeFor(this.getType(), inv, world);
    }

    public static boolean shouldIgnoreInAutomation(RecipeHolder<?> recipe) {
        RecipeSerializer serializer = recipe.value().getSerializer();
        if (serializer != null && AllTags.AllRecipeSerializerTags.AUTOMATION_IGNORE.matches(serializer)) {
            return true;
        }
        return !CAN_BE_AUTOMATED.test(recipe);
    }

    @NotNull
    public String getSerializedName() {
        return this.id.toString();
    }

    static {
        CAN_BE_AUTOMATED = r -> !r.id().getPath().endsWith("_manual_only");
        CODEC = StringRepresentable.fromEnum(CAARecipeTypes::values);
    }

    private static class Registers {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"create_aquatic_ambitions");
        private static final DeferredRegister<RecipeType<?>> TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"create_aquatic_ambitions");

        private Registers() {
        }
    }
}

