/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.storage;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.compat.ironchest.IronChestsCompat;
import xyz.przemyk.simpleplanes.container.StorageContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;

public class ChestUpgrade
extends LargeUpgrade {
    private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> ITEM_STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM);
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(27);
    public Item chestType = Items.CHEST;

    public ChestUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.CHEST.get(), planeEntity);
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag nbt = this.itemStackHandler.serializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess());
        nbt.putString("ChestType", BuiltInRegistries.ITEM.getKey((Object)this.chestType).toString());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT((HolderLookup.Provider)this.planeEntity.registryAccess(), nbt);
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString("ChestType")));
        this.chestType = item == null ? Items.CHEST : item;
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
        ITEM_STREAM_CODEC.encode((Object)buffer, (Object)Holder.direct((Object)this.chestType));
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
        this.chestType = (Item)((Holder)ITEM_STREAM_CODEC.decode((Object)buffer)).value();
    }

    @Override
    public void onRemoved() {
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            this.planeEntity.spawnAtLocation(itemStack);
        }
    }

    @Override
    public ItemStack getItemStack() {
        return this.chestType.getDefaultInstance();
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.pushPose();
        EntityType entityType = this.planeEntity.getType();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.translate(0.0, -0.1, -1.4);
        }
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.translate(-0.4, -1.0, -1.24);
        matrixStack.scale(0.82f, 0.82f, 0.82f);
        BlockState state = this.chestType instanceof BlockItem ? ((BlockItem)this.chestType).getBlock().defaultBlockState() : Blocks.CHEST.defaultBlockState();
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        matrixStack.popPose();
    }

    @Override
    public <T> T getCap(BaseCapability<T, ?> cap) {
        if (cap == Capabilities.ItemHandler.ENTITY) {
            return (T)this.itemStackHandler;
        }
        return super.getCap(cap);
    }

    @Override
    public void onApply(ItemStack itemStack) {
        this.chestType = itemStack.getItem();
        this.itemStackHandler.setSize(IronChestsCompat.getSize(BuiltInRegistries.ITEM.getKey((Object)this.chestType).toString()));
    }

    @Override
    public boolean hasStorage() {
        return true;
    }

    @Override
    public void openStorageGui(Player player, int cycleableContainerID) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new StorageContainer(id, playerInventory, (IItemHandler)this.itemStackHandler, BuiltInRegistries.ITEM.getKey((Object)this.chestType).toString(), cycleableContainerID), (Component)Component.translatable((String)"simpleplanes:chest")), buffer -> {
            buffer.writeUtf(BuiltInRegistries.ITEM.getKey((Object)this.chestType).toString());
            buffer.writeByte(cycleableContainerID);
        });
    }
}

