/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.payload;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;

public class PayloadUpgrade
extends LargeUpgrade {
    private PayloadEntry payloadEntry;

    public PayloadUpgrade(PlaneEntity planeEntity, PayloadEntry payloadEntry) {
        super(SimplePlanesUpgrades.PAYLOAD.get(), planeEntity);
        this.payloadEntry = payloadEntry;
    }

    public PayloadUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.PAYLOAD.get(), planeEntity);
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        if (this.payloadEntry != null) {
            matrixStack.pushPose();
            EntityType entityType = this.planeEntity.getType();
            if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
                matrixStack.translate(0.0, -0.1, -1.28);
            } else {
                matrixStack.translate(0.0, 0.0, 0.1);
            }
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            matrixStack.translate(-0.4, -1.0, 0.3);
            matrixStack.scale(0.82f, 0.82f, 0.82f);
            BlockState state = this.payloadEntry.renderBlock().defaultBlockState();
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
            matrixStack.popPose();
        }
    }

    @Override
    public void writePacket(RegistryFriendlyByteBuf buffer) {
        buffer.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)this.payloadEntry.item()));
        buffer.writeResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)this.payloadEntry.renderBlock()));
        buffer.writeResourceLocation(BuiltInRegistries.ENTITY_TYPE.getKey(this.payloadEntry.dropSpawnEntity()));
        buffer.writeNbt((Tag)this.payloadEntry.compoundTag());
    }

    @Override
    public void readPacket(RegistryFriendlyByteBuf buffer) {
        Item item = (Item)BuiltInRegistries.ITEM.get(buffer.readResourceLocation());
        Block renderBlock = (Block)BuiltInRegistries.BLOCK.get(buffer.readResourceLocation());
        EntityType dropSpawnEntity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(buffer.readResourceLocation());
        CompoundTag compoundTag = buffer.readNbt();
        this.payloadEntry = new PayloadEntry(item, renderBlock, dropSpawnEntity, compoundTag);
    }

    @Override
    public Tag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("item", BuiltInRegistries.ITEM.getKey((Object)this.payloadEntry.item()).toString());
        compoundTag.putString("block", BuiltInRegistries.BLOCK.getKey((Object)this.payloadEntry.renderBlock()).toString());
        compoundTag.putString("entity", BuiltInRegistries.ENTITY_TYPE.getKey(this.payloadEntry.dropSpawnEntity()).toString());
        compoundTag.put("entityTag", (Tag)this.payloadEntry.compoundTag());
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString("item")));
        Block renderBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("block")));
        EntityType dropSpawnEntity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)nbt.getString("entity")));
        this.payloadEntry = new PayloadEntry(item, renderBlock, dropSpawnEntity, nbt.getCompound("entityTag"));
    }

    @Override
    public ItemStack getItemStack() {
        return this.payloadEntry.item().getDefaultInstance();
    }

    @Override
    public boolean canBeDroppedAsPayload() {
        return true;
    }

    @Override
    public void dropAsPayload() {
        if (this.payloadEntry != null) {
            Entity entity = this.payloadEntry.dropSpawnEntity().create(this.planeEntity.level());
            entity.load(this.payloadEntry.compoundTag());
            entity.setPos(this.planeEntity.position());
            entity.setDeltaMovement(this.planeEntity.getDeltaMovement());
            this.planeEntity.level().addFreshEntity(entity);
        }
        this.remove();
    }
}

