/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.przemyk.simpleplanes.container.CycleableContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public record CyclePlaneInventoryPacket(Direction direction) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CyclePlaneInventoryPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"simpleplanes", (String)"cycle_inventory"));
    public static final StreamCodec<ByteBuf, CyclePlaneInventoryPacket> STREAM_CODEC = new StreamCodec<ByteBuf, CyclePlaneInventoryPacket>(){

        public CyclePlaneInventoryPacket decode(ByteBuf pBuffer) {
            return new CyclePlaneInventoryPacket(Direction.values()[pBuffer.readByte()]);
        }

        public void encode(ByteBuf pBuffer, CyclePlaneInventoryPacket pValue) {
            pBuffer.writeByte(pValue.direction.ordinal());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player sender = context.player();
            AbstractContainerMenu patt0$temp = sender.containerMenu;
            if (patt0$temp instanceof CycleableContainer) {
                CycleableContainer container = (CycleableContainer)patt0$temp;
                Entity patt1$temp = sender.getVehicle();
                if (patt1$temp instanceof PlaneEntity) {
                    PlaneEntity planeEntity = (PlaneEntity)patt1$temp;
                    planeEntity.openContainer(sender, this.direction == Direction.LEFT ? container.cycleableContainerID() + 1 : container.cycleableContainerID() - 1);
                }
            }
        });
    }

    public static enum Direction {
        LEFT,
        RIGHT;

    }
}

