/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.container.PlaneInventoryContainer;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;
import xyz.przemyk.simpleplanes.datapack.PlanePayloadReloadListener;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.network.CargoUpgradeRemovedPacket;
import xyz.przemyk.simpleplanes.network.DropPayloadPacket;
import xyz.przemyk.simpleplanes.network.NewCargoUpgradePacket;
import xyz.przemyk.simpleplanes.network.UpdateUpgradePacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;
import xyz.przemyk.simpleplanes.upgrades.payload.PayloadUpgrade;

public class CargoPlaneEntity
extends PlaneEntity {
    public List<LargeUpgrade> largeUpgrades = new ArrayList<LargeUpgrade>(8);

    public CargoPlaneEntity(EntityType<? extends CargoPlaneEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void tick() {
        super.tick();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.pushableBy((Entity)this));
        for (Entity entity : list) {
            if (this.level().isClientSide || this.getControllingPassenger() instanceof Player || entity.hasPassenger((Entity)this) || entity.isPassenger() || !(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.startRiding((Entity)this);
        }
    }

    @Override
    protected boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        if (super.tryToAddUpgrade(playerEntity, itemStack)) {
            return true;
        }
        if (this.largeUpgrades.size() < 8) {
            Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getLargeUpgradeFromItem(itemStack.getItem());
            if (upgradeTypeOptional.map(upgradeType -> {
                if (this.canAddUpgrade((UpgradeType)upgradeType)) {
                    Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                    this.addUpgrade(playerEntity, itemStack, upgrade);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
                return true;
            }
            PayloadEntry payloadEntry = PlanePayloadReloadListener.payloadEntries.get(itemStack.getItem());
            if (payloadEntry != null) {
                this.addUpgrade(playerEntity, itemStack, new PayloadUpgrade(this, payloadEntry));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canAddUpgrade(UpgradeType upgradeType) {
        return upgradeType != SimplePlanesUpgrades.JUKEBOX.get() && upgradeType != SimplePlanesUpgrades.SHOOTER.get() && super.canAddUpgrade(upgradeType);
    }

    @Override
    protected void addUpgrade(Player playerEntity, ItemStack itemStack, Upgrade upgrade) {
        if (!this.level().isClientSide) {
            upgrade.onApply(itemStack);
            if (!playerEntity.isCreative()) {
                itemStack.shrink(1);
            }
            UpgradeType upgradeType = upgrade.getType();
            if (upgrade instanceof LargeUpgrade) {
                LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
                this.largeUpgrades.add(largeUpgrade);
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new NewCargoUpgradePacket(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType), this.getId(), largeUpgrade), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                this.upgrades.put(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType), upgrade);
                if (upgradeType.isEngine) {
                    this.engineUpgrade = (EngineUpgrade)upgrade;
                }
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new UpdateUpgradePacket(true, SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgradeType), this.getId(), (ServerLevel)this.level()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void addCargoUpgradeIntWorkbench(ItemStack itemStack, LargeUpgrade largeUpgrade) {
        largeUpgrade.onApply(itemStack);
        this.largeUpgrades.add(largeUpgrade);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new NewCargoUpgradePacket(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)largeUpgrade.getType()), this.getId(), largeUpgrade), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void readNewCargoUpgradePacket(ResourceLocation upgradeID, ByteBuf packetBuffer) {
        UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPE.get(upgradeID);
        Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
        if (upgrade instanceof LargeUpgrade) {
            LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
            this.largeUpgrades.add(largeUpgrade);
        }
        upgrade.readPacket(new RegistryFriendlyByteBuf(packetBuffer, this.registryAccess(), ConnectionType.NEOFORGE));
    }

    @Override
    public void dropPayload() {
        for (LargeUpgrade upgrade : this.largeUpgrades) {
            if (!upgrade.canBeDroppedAsPayload()) continue;
            upgrade.dropAsPayload();
            if (upgrade.removed) {
                this.largeUpgrades.remove(upgrade);
            }
            if (!this.level().isClientSide) break;
            PacketDistributor.sendToServer((CustomPacketPayload)new DropPayloadPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            break;
        }
    }

    public void removeCargoUpgrade(int index) {
        LargeUpgrade upgrade = this.largeUpgrades.remove(index);
        upgrade.onRemoved();
        upgrade.removed = true;
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new CargoUpgradeRemovedPacket((byte)index, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected Item getItem() {
        return SimplePlanesItems.CARGO_PLANE_ITEM.get();
    }

    @Override
    protected float getGroundPitch() {
        return 0.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.CARGO_PLANE_FUEL_COST.get();
    }

    @Override
    protected boolean canAddPassenger(Entity passenger) {
        List passengers = this.getPassengers();
        if (!this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)SimplePlanesUpgrades.SEATS.get()))) {
            return passengers.size() < 2;
        }
        return passengers.size() < 6;
    }

    @Override
    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        this.positionRiderGeneric(passenger);
        int index = this.getPassengers().indexOf(passenger);
        Vector3f pos = switch (index) {
            case 0 -> this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + 1.0f, 1.5f));
            case 1 -> this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + 1.0f - 0.125f, -12.0f));
            case 2 -> this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + 1.0f - 0.625f, 2.875f));
            case 3 -> this.transformPos(new Vector3f(0.0f, this.getPassengersRidingOffset() + 1.0f - 0.625f, 3.75f));
            case 4 -> this.transformPos(new Vector3f(0.6f, this.getPassengersRidingOffset() + 1.0f - 0.625f, -6.25f));
            default -> this.transformPos(new Vector3f(-0.6f, this.getPassengersRidingOffset() + 1.0f - 0.625f, -6.25f));
        };
        moveFunction.accept(passenger, this.getX() + (double)pos.x(), this.getY() + (double)pos.y(), this.getZ() + (double)pos.z());
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.CARGO_PLANE_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    @Override
    protected float getRotationSpeedMultiplier() {
        return 0.2f;
    }

    @Override
    public void openContainer(Player player, int containerID) {
        if (containerID == 0) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, playerIn) -> new PlaneInventoryContainer(id, inventory, this), this.getName()), buffer -> buffer.writeVarInt(this.getId()));
        } else {
            int id2 = 0;
            for (LargeUpgrade upgrade : this.largeUpgrades) {
                if (!upgrade.hasStorage() || containerID != ++id2) continue;
                upgrade.openStorageGui(player, id2);
            }
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("large_upgrades")) {
            ListTag listTag = compound.getList("large_upgrades", 10);
            this.largeUpgrades.clear();
            for (int i = 0; i < listTag.size(); ++i) {
                Upgrade upgrade;
                CompoundTag compoundTag = listTag.getCompound(i);
                UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPE.get(ResourceLocation.parse((String)compoundTag.getString("id")));
                if (upgradeType == null || !((upgrade = upgradeType.instanceSupplier.apply(this)) instanceof LargeUpgrade)) continue;
                LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
                largeUpgrade.deserializeNBT(compoundTag.getCompound("nbt"));
                this.largeUpgrades.add(largeUpgrade);
            }
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ListTag listTag = new ListTag();
        for (LargeUpgrade upgrade : this.largeUpgrades) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("id", SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgrade.getType()).toString());
            compoundTag.put("nbt", upgrade.serializeNBT());
            listTag.add((Object)compoundTag);
        }
        compound.put("large_upgrades", (Tag)listTag);
    }

    @Override
    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeVarInt(this.largeUpgrades.size());
        for (LargeUpgrade upgrade : this.largeUpgrades) {
            ResourceLocation upgradeID = SimplePlanesRegistries.UPGRADE_TYPE.getKey((Object)upgrade.getType());
            buffer.writeResourceLocation(upgradeID);
            upgrade.writePacket(buffer);
        }
    }

    @Override
    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        super.readSpawnData(additionalData);
        int largeUpgradesSize = additionalData.readVarInt();
        for (int i = 0; i < largeUpgradesSize; ++i) {
            ResourceLocation upgradeID = additionalData.readResourceLocation();
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPE.get(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.largeUpgrades.add((LargeUpgrade)upgrade);
            upgrade.readPacket(additionalData);
        }
    }
}

