/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import xyz.przemyk.simpleplanes.client.render.models.ParachuteModel;
import xyz.przemyk.simpleplanes.entities.ParachuteEntity;

public class ParachuteRenderer
extends EntityRenderer<ParachuteEntity> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/white_wool.png");
    private final ParachuteModel parachuteModel;

    public ParachuteRenderer(EntityRendererProvider.Context context, ParachuteModel parachuteModel) {
        super(context);
        this.parachuteModel = parachuteModel;
    }

    public ResourceLocation getTextureLocation(ParachuteEntity p_114482_) {
        return TEXTURE;
    }

    public void render(ParachuteEntity parachuteEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packetLight) {
        poseStack.pushPose();
        if (parachuteEntity.hasStorageCrate()) {
            poseStack.pushPose();
            poseStack.translate(-0.5, 0.0, -0.5);
            BlockState state = Blocks.BARREL.defaultBlockState();
            Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, poseStack, buffer, packetLight, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
            poseStack.popPose();
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0, -2.0, 0.0);
        } else {
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0, -3.0, 0.0);
        }
        VertexConsumer vertexConsumer = buffer.getBuffer(this.parachuteModel.renderType(this.getTextureLocation(parachuteEntity)));
        this.parachuteModel.renderToBuffer(poseStack, vertexConsumer, packetLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)parachuteEntity, entityYaw, partialTicks, poseStack, buffer, packetLight);
    }
}

