/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.compat.ironchest.IronChestsCompat;
import xyz.przemyk.simpleplanes.container.StorageContainer;
import xyz.przemyk.simpleplanes.network.CyclePlaneInventoryPacket;

public class StorageScreen
extends AbstractContainerScreen<StorageContainer> {
    public final ResourceLocation texture;
    public final int textureYSize;

    public StorageScreen(StorageContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.imageHeight = IronChestsCompat.getYSize(screenContainer.chestType);
        this.imageWidth = IronChestsCompat.getXSize(screenContainer.chestType);
        this.inventoryLabelY = this.imageHeight - 94;
        this.texture = IronChestsCompat.getGuiTexture(screenContainer.chestType);
        this.textureYSize = IronChestsCompat.getTextureYSize(screenContainer.chestType);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 3, this.topPos + 54, 10, 15, PlaneInventoryScreen.LEFT_BUTTON_SPRITES, button -> PacketDistributor.sendToServer((CustomPacketPayload)new CyclePlaneInventoryPacket(CyclePlaneInventoryPacket.Direction.LEFT), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + this.imageWidth - 13, this.topPos + 54, 10, 15, PlaneInventoryScreen.RIGHT_BUTTON_SPRITES, button -> PacketDistributor.sendToServer((CustomPacketPayload)new CyclePlaneInventoryPacket(CyclePlaneInventoryPacket.Direction.RIGHT), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.texture, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, this.textureYSize);
    }
}

