/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import xyz.przemyk.simpleplanes.network.JukeboxPacket;

public class MovingSound
extends AbstractTickableSoundInstance {
    public static final Map<Entity, SoundInstance> playingRecords = Maps.newHashMap();
    private final Entity entity;

    public MovingSound(SoundEvent soundEvent, Entity entity) {
        super(soundEvent, SoundSource.RECORDS, SoundInstance.createUnseededRandom());
        this.entity = entity;
    }

    public void tick() {
        if (!this.entity.isAlive()) {
            this.stop();
        } else {
            this.x = this.entity.getX();
            this.y = this.entity.getY();
            this.z = this.entity.getZ();
        }
    }

    public static void playRecord(JukeboxPacket jukeboxPacket) {
        Minecraft minecraft = Minecraft.getInstance();
        Entity entity = minecraft.level.getEntity(jukeboxPacket.planeEntityID());
        JukeboxSong.fromStack((HolderLookup.Provider)minecraft.level.registryAccess(), (ItemStack)((Item)BuiltInRegistries.ITEM.get(jukeboxPacket.record())).getDefaultInstance()).ifPresent(h -> {
            JukeboxSong jukeboxSong = (JukeboxSong)h.value();
            SoundInstance soundInstance = playingRecords.get(entity);
            if (soundInstance != null) {
                minecraft.getSoundManager().stop(soundInstance);
                playingRecords.remove(entity);
            }
            minecraft.gui.setNowPlaying(jukeboxSong.description());
            MovingSound movingSound = new MovingSound((SoundEvent)jukeboxSong.soundEvent().value(), entity);
            playingRecords.put(entity, (SoundInstance)movingSound);
            minecraft.getSoundManager().play((SoundInstance)movingSound);
        });
    }

    public static void play(SoundEvent event, Entity entity) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new MovingSound(event, entity));
    }

    public static void remove(Entity entity) {
        SoundInstance soundInstance = playingRecords.get(entity);
        if (soundInstance != null) {
            Minecraft.getInstance().getSoundManager().stop(soundInstance);
            playingRecords.remove(entity);
        }
    }
}

