/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.CalculateDetachedCameraDistanceEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.ChangeThrottlePacket;
import xyz.przemyk.simpleplanes.network.MoveHeliUpPacket;
import xyz.przemyk.simpleplanes.network.OpenPlaneInventoryPacket;
import xyz.przemyk.simpleplanes.network.PitchPacket;
import xyz.przemyk.simpleplanes.network.YawPacket;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEventHandler {
    public static KeyMapping moveHeliUpKey;
    public static KeyMapping openPlaneInventoryKey;
    public static KeyMapping dropPayloadKey;
    public static KeyMapping throttleUp;
    public static KeyMapping throttleDown;
    public static KeyMapping pitchUp;
    public static KeyMapping pitchDown;
    public static KeyMapping yawRight;
    public static KeyMapping yawLeft;
    private static boolean oldMoveHeliUpState;
    private static boolean oldPitchUpState;
    private static boolean oldPitchDownState;
    private static boolean oldYawRightState;
    private static boolean oldYawLeftState;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPre(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.getRootVehicle();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            PoseStack matrixStack = event.getPoseStack();
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.375, 0.0);
            Quaternionf quaternion = MathUtil.lerpQ(event.getPartialTick(), planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.set(quaternion.x(), -quaternion.y(), -quaternion.z(), quaternion.w());
            matrixStack.mulPose(quaternion);
            float rotationYaw = MathUtil.lerpAngle(event.getPartialTick(), entity.yRotO, entity.getYRot());
            matrixStack.mulPose(Axis.YP.rotationDegrees(rotationYaw));
            matrixStack.translate(0.0, -0.375, 0.0);
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.yHeadRot = planeEntity.getYRot() * 2.0f - livingEntity.yHeadRot;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.yHeadRotO = planeEntity.yRotO * 2.0f - livingEntity.yHeadRotO;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPost(RenderLivingEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = livingEntity.getRootVehicle();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            event.getPoseStack().popPose();
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.yHeadRot = planeEntity.getYRot() * 2.0f - event.getEntity().yHeadRot;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.yHeadRotO = planeEntity.yRotO * 2.0f - event.getEntity().yHeadRotO;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClientPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof LocalPlayer) {
            Entity entity = player.getVehicle();
            if (entity instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)entity;
                Minecraft mc = Minecraft.getInstance();
                if (mc.options.getCameraType() != CameraType.FIRST_PERSON) {
                    planeEntity.applyYawToEntity((Entity)player);
                }
                if (mc.screen == null && mc.getOverlay() == null && openPlaneInventoryKey.consumeClick()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new OpenPlaneInventoryPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (dropPayloadKey.consumeClick()) {
                    planeEntity.dropPayload();
                }
                if (throttleUp.consumeClick()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ChangeThrottlePacket(ChangeThrottlePacket.Direction.UP), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else if (throttleDown.consumeClick()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ChangeThrottlePacket(ChangeThrottlePacket.Direction.DOWN), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                boolean isMoveHeliUp = moveHeliUpKey.isDown();
                boolean isPitchUp = pitchUp.isDown();
                boolean isPitchDown = pitchDown.isDown();
                boolean isYawRight = yawRight.isDown();
                boolean isYawLeft = yawLeft.isDown();
                if (isMoveHeliUp != oldMoveHeliUpState) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new MoveHeliUpPacket(isMoveHeliUp), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (isPitchUp != oldPitchUpState || isPitchDown != oldPitchDownState) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new PitchPacket((byte)Boolean.compare(isPitchUp, isPitchDown)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (isYawRight != oldYawRightState || isYawLeft != oldYawLeftState) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new YawPacket((byte)Boolean.compare(isYawRight, isYawLeft)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                oldMoveHeliUpState = isMoveHeliUp;
                oldPitchUpState = isPitchUp;
                oldPitchDownState = isPitchDown;
                oldYawRightState = isYawRight;
                oldYawLeftState = isYawLeft;
            } else {
                oldMoveHeliUpState = false;
                oldPitchUpState = false;
                oldPitchDownState = false;
                oldYawRightState = false;
                oldYawLeftState = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Camera camera = event.getCamera();
        Entity player = camera.getEntity();
        Entity entity = player.getVehicle();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            if (!camera.isDetached()) {
                double partialTicks = event.getPartialTick();
                Quaternionf qPrev = planeEntity.getQ_Prev();
                Quaternionf qNow = planeEntity.getQ_Client();
                qPrev.mul((Quaternionfc)Axis.YP.rotationDegrees(player.yRotO));
                qPrev.mul((Quaternionfc)Axis.XP.rotationDegrees(event.getPitch()));
                MathUtil.EulerAngles eulerAnglesPrev = MathUtil.toEulerAngles(qPrev);
                qNow.mul((Quaternionfc)Axis.YP.rotationDegrees(player.getYRot()));
                qNow.mul((Quaternionfc)Axis.XP.rotationDegrees(event.getPitch()));
                MathUtil.EulerAngles eulerAnglesNow = MathUtil.toEulerAngles(qNow);
                event.setPitch(-((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.pitch, eulerAnglesNow.pitch)));
                event.setYaw((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.yaw, eulerAnglesNow.yaw));
                event.setRoll(-((float)MathUtil.lerpAngle(partialTicks, eulerAnglesPrev.roll, eulerAnglesNow.roll)));
            }
        }
    }

    @SubscribeEvent
    public static void onCalculateDetachedCameraDistance(CalculateDetachedCameraDistanceEvent event) {
        Entity entity = event.getCamera().getEntity().getVehicle();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            event.setDistance((float)(4.0 * planeEntity.getCameraDistanceMultiplayer()));
        }
    }

    static {
        oldMoveHeliUpState = false;
        oldPitchUpState = false;
        oldPitchDownState = false;
        oldYawRightState = false;
        oldYawLeftState = false;
    }
}

