/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum NetworkPermission implements StringRepresentable
{
    NONE,
    MEMBER,
    ADMIN,
    OWNER;

    public static final IntFunction<NetworkPermission> BY_ID;
    public static final StreamCodec<ByteBuf, NetworkPermission> STREAM_CODEC;
    public static final Codec<NetworkPermission> CODEC;

    public NetworkPermission next() {
        int nextOrdinal = (this.ordinal() + 1) % NetworkPermission.values().length;
        return NetworkPermission.values()[nextOrdinal];
    }

    public NetworkPermission previous() {
        int prevOrdinal = (this.ordinal() - 1 + NetworkPermission.values().length) % NetworkPermission.values().length;
        return NetworkPermission.values()[prevOrdinal];
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])NetworkPermission.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        CODEC = Codec.INT.flatXmap(id -> {
            NetworkPermission p = BY_ID.apply((int)id);
            if (p == null) {
                return DataResult.error(() -> "Unknown NetworkPermission id: " + id);
            }
            return DataResult.success((Object)((Object)p));
        }, perm -> DataResult.success((Object)perm.ordinal()));
    }
}

