/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.refinedradiance;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.DestroyUtils;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class RefinedRadiancePickaxe
extends PickaxeItem
implements QOLConfigurableItem {
    public RefinedRadiancePickaxe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.REFINED_RADIANCE, p_42964_);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.inventoryTick(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!((ItemTooltips)stack.getOrDefault(QOLDataComponents.ITEM_TOOLTIPS, (Object)ItemTooltips.DEFAULT)).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.reach").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.REACH, (Object)true), false, true)));
        components.add((Component)Component.translatable((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.translatable((String)"createqol.ability.tool.vein_mine").getString()}).withStyle(ChatFormatting.GOLD).append(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.veinMine.get(), true, (Boolean)stack.getOrDefault(QOLDataComponents.VEIN_MINE, (Object)false), false, true)));
        super.appendHoverText(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Vein Mine", (Boolean)stack.getOrDefault(QOLDataComponents.VEIN_MINE, (Object)false), QOLDataComponents.VEIN_MINE, List.of("Should all the blocks of the same types be destroy when mining"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.veinMine.get()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide) {
            return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)true);
        }
        if (player.isCrouching()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        RefinedRadiancePickaxe.toggleAbility(player.getItemInHand(hand), player);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.veinMine.get()).booleanValue()) {
            p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.vein_mine", new Object[0]).getString()).withStyle(ChatFormatting.RED), true);
            return;
        }
        boolean enable = (Boolean)stack.getOrDefault(QOLDataComponents.VEIN_MINE, (Object)false) == false;
        stack.set(QOLDataComponents.VEIN_MINE, (Object)enable);
        p.displayClientMessage((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.vein_mine", new Object[0]).getString()).append(QOLConfigurableItem.chooseState(true, true, enable, false, true)).withStyle(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isBarVisible(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarWidth(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int getBarColor(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().getMainHandItem().is((Item)QOLItems.REFINED_RADIANCE_PICKAXE.get()) && !event.getPlayer().getMainHandItem().is((Item)QOLItems.SHADOW_RADIANCE_PICKAXE.get())) {
            return;
        }
        if (!((Boolean)event.getPlayer().getMainHandItem().getOrDefault(QOLDataComponents.VEIN_MINE, (Object)false)).booleanValue()) {
            return;
        }
        if (!event.getPlayer().getMainHandItem().isCorrectToolForDrops(event.getState())) {
            return;
        }
        int max = (Integer)CreateQOLConfigs.server().equipments.tools.veinMineMaxBlocks.get();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toExplore = new ArrayDeque<BlockPos>();
        List<BlockPos> first = RefinedRadiancePickaxe.getValidBlocksNextTo(event.getLevel(), event.getPos(), event.getPlayer().getMainHandItem());
        for (BlockPos pos : first) {
            if (!event.getLevel().getBlockState(pos).is(event.getState().getBlock())) continue;
            visited.add(pos);
            toExplore.add(pos);
            if (visited.size() < max) continue;
            break;
        }
        block1: while (!toExplore.isEmpty() && visited.size() < max) {
            BlockPos current = (BlockPos)toExplore.poll();
            List<BlockPos> neighbors = RefinedRadiancePickaxe.getValidBlocksNextTo(event.getLevel(), current, event.getPlayer().getMainHandItem());
            for (BlockPos neighbor : neighbors) {
                if (visited.size() >= max) continue block1;
                if (visited.contains(neighbor) || !event.getLevel().getBlockState(neighbor).is(event.getState().getBlock())) continue;
                visited.add(neighbor);
                toExplore.add(neighbor);
            }
        }
        visited.forEach(p -> DestroyUtils.destroyBlock(event.getPlayer().level(), ((ServerPlayer)event.getPlayer()).gameMode.getGameModeForPlayer(), event.getPlayer(), ((ServerPlayer)event.getPlayer()).gameMode, p, event.getPos()));
    }

    private static List<BlockPos> getValidBlocksNextTo(LevelAccessor level, BlockPos pos, ItemStack stack) {
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (Direction direction : Iterate.directions) {
            if (!stack.isCorrectToolForDrops(level.getBlockState(pos.relative(direction)))) continue;
            poses.add(pos.relative(direction));
        }
        return poses;
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }
}

