/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import fr.iglee42.createqualityoflife.registries.QOLBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StockManagerBlockItem
extends LogisticallyLinkedBlockItem {
    private final boolean capturedBlaze;

    public static StockManagerBlockItem empty(Item.Properties properties) {
        return new StockManagerBlockItem((Block)QOLBlocks.STOCK_MANAGER.get(), properties, false);
    }

    public static StockManagerBlockItem withBlaze(Block block, Item.Properties properties) {
        return new StockManagerBlockItem(block, properties, true);
    }

    public void registerBlocks(Map<Block, Item> p_195946_1_, Item p_195946_2_) {
        if (!this.hasCapturedBlaze()) {
            return;
        }
        super.registerBlocks(p_195946_1_, p_195946_2_);
    }

    private StockManagerBlockItem(Block block, Item.Properties properties, boolean capturedBlaze) {
        super(block, properties);
        this.capturedBlaze = capturedBlaze;
    }

    public String getDescriptionId() {
        return this.hasCapturedBlaze() ? super.getDescriptionId() : "item.createqol." + RegisteredObjectsHelper.getKeyOrThrow((Item)this).getPath();
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this.hasCapturedBlaze()) {
            return super.useOn(context);
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity be = world.getBlockEntity(pos);
        Player player = context.getPlayer();
        if (!(be instanceof SpawnerBlockEntity)) {
            InteractionResult interactionresult = this.place(new BlockPlaceContext(context));
            if (!interactionresult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD)) {
                InteractionResult interactionresult1 = super.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
                return interactionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionresult1;
            }
            return interactionresult;
        }
        BaseSpawner spawner = ((SpawnerBlockEntity)be).getSpawner();
        List<SpawnData> possibleSpawns = spawner.spawnPotentials.unwrap().stream().map(WeightedEntry.Wrapper::data).toList();
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<SpawnData>();
            possibleSpawns.add(spawner.nextSpawnData);
        }
        for (SpawnData e : possibleSpawns) {
            Optional optionalEntity = EntityType.by((CompoundTag)e.entityToSpawn());
            if (optionalEntity.isEmpty() || !AllTags.AllEntityTags.BLAZE_BURNER_CAPTURABLE.matches((EntityType)optionalEntity.get())) continue;
            this.spawnCaptureEffects(world, VecHelper.getCenterOf((Vec3i)pos));
            if (world.isClientSide || player == null) {
                return InteractionResult.SUCCESS;
            }
            this.giveBurnerItemTo(player, context.getItemInHand(), context.getHand());
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionresult = this.place(new BlockPlaceContext(context));
        if (!interactionresult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD)) {
            InteractionResult interactionresult1 = super.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
            return interactionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : interactionresult1;
        }
        return interactionresult;
    }

    public InteractionResult interactLivingEntity(ItemStack heldItem, Player player, LivingEntity entity, InteractionHand hand) {
        if (this.hasCapturedBlaze()) {
            return InteractionResult.PASS;
        }
        if (!AllTags.AllEntityTags.BLAZE_BURNER_CAPTURABLE.matches((Entity)entity)) {
            return InteractionResult.PASS;
        }
        Level world = player.level();
        this.spawnCaptureEffects(world, entity.position());
        if (world.isClientSide) {
            return InteractionResult.FAIL;
        }
        this.giveBurnerItemTo(player, heldItem, hand);
        entity.discard();
        return InteractionResult.FAIL;
    }

    protected void giveBurnerItemTo(Player player, ItemStack heldItem, InteractionHand hand) {
        ItemStack filled = QOLBlocks.STOCK_MANAGER.asStack();
        if (!player.isCreative()) {
            heldItem.shrink(1);
        }
        if (heldItem.isEmpty()) {
            player.setItemInHand(hand, filled);
            return;
        }
        player.getInventory().placeItemBackInInventory(filled);
    }

    private void spawnCaptureEffects(Level world, Vec3 vec) {
        if (world.isClientSide) {
            for (int i = 0; i < 40; ++i) {
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)world.random, (float)0.125f);
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, vec.x, vec.y, vec.z, motion.x, motion.y, motion.z);
                Vec3 circle = motion.multiply(1.0, 0.0, 1.0).normalize().scale(0.5);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, circle.x, vec.y, circle.z, 0.0, -0.125, 0.0);
            }
            return;
        }
        BlockPos soundPos = BlockPos.containing((Position)vec);
        world.playSound(null, soundPos, SoundEvents.BLAZE_HURT, SoundSource.HOSTILE, 0.25f, 0.75f);
        world.playSound(null, soundPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.HOSTILE, 0.5f, 0.75f);
    }

    public boolean hasCapturedBlaze() {
        return this.capturedBlaze;
    }
}

