/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.NotUpdatableEditBox;
import fr.iglee42.createqualityoflife.client.screens.widgets.ScrollableEditBox;
import fr.iglee42.createqualityoflife.packets.PublishAnimationPacket;
import fr.iglee42.createqualityoflife.registries.QOLGuiTextures;
import fr.iglee42.createqualityoflife.registries.QOLIcons;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimation;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimationFrame;
import fr.iglee42.createqualityoflife.statue.animation.StatuePartTable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Items;

public class AnimationTab
extends StatueTab {
    public static final int LOOP_X = 0;
    public static final int REVERT_X = 22;
    public static final int COPY_ALL_X = 44;
    private static final List<Component> LOOP_TOOLTIPS = List.of(CreateLang.translateDirect((String)"schedule.loop", (Object[])new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionDisabled", (Object[])new Object[0]).withStyle(ChatFormatting.RED));
    private static final List<Component> ON_LOOP_TOOLTIPS = List.of(CreateLang.translateDirect((String)"schedule.loop", (Object[])new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionEnabled", (Object[])new Object[0]).withStyle(ChatFormatting.GREEN));
    private static final List<Component> REVERSE_TOOLTIPS = List.of(CreateQOLLang.translateDirect("statue.animation.revert", new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionDisabled", (Object[])new Object[0]).withStyle(ChatFormatting.RED), CreateQOLLang.translateDirect("statue.animation.revert_1", new Object[0]), CreateQOLLang.translateDirect("statue.animation.revert_2", new Object[0]));
    private static final List<Component> ON_REVERSE_TOOLTIPS = List.of(CreateQOLLang.translateDirect("statue.animation.revert", new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionEnabled", (Object[])new Object[0]).withStyle(ChatFormatting.GREEN), CreateQOLLang.translateDirect("statue.animation.revert_1", new Object[0]), CreateQOLLang.translateDirect("statue.animation.revert_2", new Object[0]));
    private static final List<Component> COPY_ALL_TOOLTIPS = List.of(CreateQOLLang.translateDirect("statue.animation.copy_all", new Object[0]), CreateQOLLang.translateDirect("statue.animation.copy_all_1", new Object[0]), CreateQOLLang.translateDirect("statue.animation.copy_all_2", new Object[0]));
    private StatueAnimation animation;
    private IconButton loopButton;
    private IconButton revertButton;
    private IconButton createButton;
    private IconButton copyAllButton;
    private NotUpdatableEditBox frameSelector;
    private IconButton previousFrameButton;
    private IconButton nextFrameButton;
    private IconButton deleteFrameButton;
    private IconButton publishButton;
    private EditBox nameEdit;
    List<ScrollableEditBox> editWidgets;
    List<IconButton> iconButtons;
    private int currentFrame;

    public AnimationTab(int index, ConfigureStatueScreen parent) {
        super(index, Items.NETHER_STAR, parent, "statue.animationTab");
        this.animation = parent.getExampleStatue().getAnimation().orElse(null);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        y -= 14;
        this.createButton.visible = this.animation == null || this.getCurrentFrame() == null;
        this.loopButton.visible = this.animation != null;
        this.revertButton.visible = this.animation != null;
        this.editWidgets.forEach(b -> {
            b.visible = this.animation != null && this.getCurrentFrame() != null;
        });
        this.iconButtons.forEach(b -> {
            b.visible = this.animation != null && this.getCurrentFrame() != null;
        });
        this.copyAllButton.visible = this.animation != null && this.getCurrentFrame() != null;
        this.deleteFrameButton.visible = this.animation != null && this.getCurrentFrame() != null;
        this.frameSelector.visible = this.animation != null;
        this.previousFrameButton.visible = this.animation != null;
        this.previousFrameButton.active = this.previousFrameButton.visible && this.getCurrentFrame() != null && this.animation.getPreviousFrame(this.getCurrentFrame()) != null;
        this.nextFrameButton.visible = this.animation != null;
        this.nextFrameButton.active = this.nextFrameButton.visible && this.getCurrentFrame() != null && this.animation.getNextFrame(this.getCurrentFrame()) != null;
        this.publishButton.visible = this.animation != null;
        boolean bl = this.nameEdit.visible = this.animation != null;
        if (this.animation != null) {
            this.loopButton.getToolTip().clear();
            this.revertButton.getToolTip().clear();
            this.loopButton.getToolTip().addAll(this.loopButton.green ? ON_LOOP_TOOLTIPS : LOOP_TOOLTIPS);
            this.revertButton.getToolTip().addAll(this.revertButton.green ? ON_REVERSE_TOOLTIPS : REVERSE_TOOLTIPS);
            this.animation.setLoop(this.loopButton.green);
            this.animation.setRevert(this.revertButton.green);
        }
        if (this.animation != null && this.getCurrentFrame() != null) {
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 4 + 20);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 6 + 40);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 8 + 60);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 10 + 80);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 12 + 100);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 14 + 120);
        }
        if (this.animation != null) {
            QOLGuiTextures.NAME_EDIT_BOX.render(graphics, x + 2 + 0 + 19, y + 173 - 19);
            QOLGuiTextures.SIMPLE_EDIT_BOX.render(graphics, this.getParent().getGuiLeft() + this.getParent().imageWidth / 2 - 25 + Minecraft.getInstance().font.width((FormattedText)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0])), this.getParent().getGuiTop() + this.getParent().imageHeight - 24);
            graphics.drawString(Minecraft.getInstance().font, (Component)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0]), this.getParent().getGuiLeft() + this.getParent().imageWidth / 2 - 25, this.getParent().getGuiTop() + this.getParent().imageHeight - 24 + 5 - 1, 0xFFFFFF);
        }
        if (this.animation != null && this.getCurrentFrame() == null) {
            graphics.drawWordWrap(Minecraft.getInstance().font, (FormattedText)CreateQOLLang.translateDirect("statue.animation.frame.create", new Object[0]), x + 6, y + 86 - 64, 119, 0xFFFFFF);
        } else if (this.animation == null) {
            graphics.drawWordWrap(Minecraft.getInstance().font, (FormattedText)CreateQOLLang.translateDirect("statue.animation.create", new Object[0]), x + 6, y + 86 - 64, 119, 0xFFFFFF);
        }
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        function.accept((AbstractWidget)this.createButton);
        function.accept((AbstractWidget)this.loopButton);
        function.accept((AbstractWidget)this.revertButton);
        function.accept((AbstractWidget)this.copyAllButton);
        function.accept((AbstractWidget)this.frameSelector);
        function.accept((AbstractWidget)this.previousFrameButton);
        function.accept((AbstractWidget)this.nextFrameButton);
        function.accept((AbstractWidget)this.deleteFrameButton);
        function.accept((AbstractWidget)this.publishButton);
        function.accept((AbstractWidget)this.nameEdit);
        this.editWidgets.forEach(function);
        this.iconButtons.forEach(function);
    }

    @Override
    public void initWidgets(int x, int y) {
        this.createButton = new IconButton(x + 61, (y -= 14) + 77, (ScreenElement)AllIcons.I_ADD);
        this.createButton.withCallback(this::createButtonCallback);
        this.loopButton = new IconButton(x + 2 + 0, y + 2, (ScreenElement)AllIcons.I_REFRESH);
        this.loopButton.withCallback(() -> {
            this.loopButton.green = !this.loopButton.green;
        });
        this.revertButton = new IconButton(x + 2 + 22, y + 2, (ScreenElement)AllIcons.I_CONFIG_BACK);
        this.revertButton.withCallback(() -> {
            this.revertButton.green = !this.revertButton.green;
        });
        this.copyAllButton = new IconButton(x + 2 + 44, y + 2, (ScreenElement)AllIcons.I_TARGET);
        this.copyAllButton.withCallback(() -> {
            this.updateRotation(f -> f.withGlobalRotation(this.getExampleStatue().getEntityXRotation(), this.getExampleStatue().getYRot(), this.getExampleStatue().getEntityZRotation()).withHeadRotation(this.getExampleStatue().getHeadPose().getX(), this.getExampleStatue().getHeadPose().getY(), this.getExampleStatue().getHeadPose().getZ()).withLeftArmRotation(this.getExampleStatue().getLeftArmPose().getX(), this.getExampleStatue().getLeftArmPose().getY(), this.getExampleStatue().getLeftArmPose().getZ()).withRightArmRotation(this.getExampleStatue().getRightArmPose().getX(), this.getExampleStatue().getRightArmPose().getY(), this.getExampleStatue().getRightArmPose().getZ()).withLeftLegRotation(this.getExampleStatue().getLeftLegPose().getX(), this.getExampleStatue().getLeftLegPose().getY(), this.getExampleStatue().getLeftLegPose().getZ()).withRightLegRotation(this.getExampleStatue().getRightLegPose().getX(), this.getExampleStatue().getRightLegPose().getY(), this.getExampleStatue().getRightLegPose().getZ()));
            this.updateBoxesFromFrame(this.currentFrame);
        });
        this.copyAllButton.getToolTip().addAll(COPY_ALL_TOOLTIPS);
        this.deleteFrameButton = new IconButton(x + 2 + 44 + 22, y + 2, (ScreenElement)AllIcons.I_CONFIG_DISCARD);
        this.deleteFrameButton.withCallback(() -> this.animation.deleteFrame(this.getCurrentFrame()));
        this.deleteFrameButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.delete_frame", new Object[0]));
        this.frameSelector = new NotUpdatableEditBox(Minecraft.getInstance().font, this.getParent().getGuiLeft() + this.getParent().imageWidth / 2 - 23 + Minecraft.getInstance().font.width((FormattedText)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0])), this.getParent().getGuiTop() + this.getParent().imageHeight - 24 + 5, 32, 18, CommonComponents.EMPTY);
        this.frameSelector.setBordered(false);
        this.frameSelector.setValue("" + this.currentFrame);
        this.frameSelector.setMaxLength(4);
        this.frameSelector.setTextColor(0xFFFFFF);
        this.frameSelector.setFocused(false);
        this.frameSelector.mouseClicked(0.0, 0.0, 0);
        this.frameSelector.setResponder(s -> {
            if (!s.isEmpty()) {
                try {
                    this.changeFrame(Integer.parseInt(s), true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.frameSelector.setFilter(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int i = Integer.parseInt(s);
                return i >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.previousFrameButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().imageWidth / 2 - 23 - 22, this.getParent().getGuiTop() + this.getParent().imageHeight - 24, (ScreenElement)AllIcons.I_CONFIG_BACK);
        this.previousFrameButton.withCallback(() -> {
            if (this.animation != null && this.animation.getPreviousFrame(this.getCurrentFrame()) != null) {
                this.changeFrame(this.animation.getPreviousFrame(this.getCurrentFrame()).getTick(), false);
            }
        });
        this.previousFrameButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.previous_frame", new Object[0]));
        this.nextFrameButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().imageWidth / 2 - 23 + Minecraft.getInstance().font.width((FormattedText)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0])) + 26, this.getParent().getGuiTop() + this.getParent().imageHeight - 24, (ScreenElement)AllIcons.I_CONFIG_OPEN);
        this.nextFrameButton.withCallback(() -> {
            if (this.animation != null && this.animation.getNextFrame(this.getCurrentFrame()) != null) {
                this.changeFrame(this.animation.getNextFrame(this.getCurrentFrame()).getTick(), false);
            }
        });
        this.nextFrameButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.next_frame", new Object[0]));
        this.publishButton = new IconButton(x + 2 + 0, y + 173 - 19, (ScreenElement)AllIcons.I_SEND_ONLY);
        this.publishButton.withCallback(() -> {
            if (!this.nameEdit.getValue().isEmpty()) {
                CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new PublishAnimationPacket(Minecraft.getInstance().player.getUUID(), this.nameEdit.getValue(), this.animation));
            }
        });
        this.publishButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.publish", new Object[0]));
        this.nameEdit = new EditBox(Minecraft.getInstance().font, x + 2 + 0 + 21, y + 173 - 19 + 5, 99, 18, CommonComponents.EMPTY);
        this.nameEdit.setBordered(false);
        this.nameEdit.setFocused(false);
        this.nameEdit.setHint((Component)CreateQOLLang.translateDirect("statue.animation.publishName", new Object[0]));
        this.nameEdit.setTooltip(Tooltip.create((Component)CreateQOLLang.translateDirect("statue.name_utility", new Object[0])));
        if (this.animation != null) {
            this.loopButton.green = this.animation.isLooping();
            this.revertButton.green = this.animation.canBeRevert();
        }
        int offsetY = 22;
        this.editWidgets = new ArrayList<ScrollableEditBox>();
        this.iconButtons = new ArrayList<IconButton>();
        this.setupRotationControls(x, y + offsetY, QOLIcons.I_STATUE, () -> this.getCurrentFrame().getGlobal(), () -> this.getExampleStatue().getEntityRotations(), this::updateGlobal, rot -> frame -> frame.withGlobalRotation(rot.getX(), rot.getY(), rot.getZ()), PlayerModelPart.CAPE, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_HAT, () -> this.getCurrentFrame().getHead(), () -> this.getExampleStatue().getHeadPose(), this::updateHead, rot -> frame -> frame.withHeadRotation(rot.getX(), rot.getY(), rot.getZ()), PlayerModelPart.HAT, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_LEFT_SLEEVE, () -> this.getCurrentFrame().getLeftArm(), () -> this.getExampleStatue().getLeftArmPose(), this::updateLeftArm, rot -> frame -> frame.withLeftArmRotation(rot.getX(), rot.getY(), rot.getZ()), PlayerModelPart.LEFT_SLEEVE, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_RIGHT_SLEEVE, () -> this.getCurrentFrame().getRightArm(), () -> this.getExampleStatue().getRightArmPose(), this::updateRightArm, rot -> frame -> frame.withRightArmRotation(rot.getX(), rot.getY(), rot.getZ()), PlayerModelPart.RIGHT_SLEEVE, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_LEFT_PANTS, () -> this.getCurrentFrame().getLeftLeg(), () -> this.getExampleStatue().getLeftLegPose(), this::updateLeftLeg, rot -> frame -> frame.withLeftLegRotation(rot.getX(), rot.getY(), rot.getZ()), PlayerModelPart.LEFT_PANTS_LEG, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_RIGHT_PANTS, () -> this.getCurrentFrame().getRightLeg(), () -> this.getExampleStatue().getRightLegPose(), this::updateRightLeg, rot -> frame -> frame.withRightLegRotation(rot.getX(), rot.getY(), rot.getZ()), PlayerModelPart.RIGHT_PANTS_LEG, this.editWidgets, this.iconButtons);
    }

    private void setupRotationControls(int x, int yOffset, QOLIcons icon, Supplier<StatuePartTable> currentFrameSupplier, Supplier<Rotations> defaultPoseSupplier, BiConsumer<Character, Integer> updater, Function<Rotations, Function<StatueAnimationFrame, StatueAnimationFrame>> rotationSetter, PlayerModelPart tooltipPart, List<ScrollableEditBox> collector, List<IconButton> buttons) {
        ScrollableEditBox boxX = new ScrollableEditBox(Minecraft.getInstance().font, x + 20 + 2 + 4, yOffset + 5 + 2, 32, 18, CommonComponents.EMPTY);
        ScrollableEditBox boxY = new ScrollableEditBox(Minecraft.getInstance().font, x + 20 + 2 + 4 + 30, yOffset + 5 + 2, 32, 18, CommonComponents.EMPTY);
        ScrollableEditBox boxZ = new ScrollableEditBox(Minecraft.getInstance().font, x + 20 + 2 + 4 + 60, yOffset + 5 + 2, 32, 18, CommonComponents.EMPTY);
        boxX.setPrefix((Component)Component.literal((String)"X: "));
        boxY.setPrefix((Component)Component.literal((String)"Y: "));
        boxZ.setPrefix((Component)Component.literal((String)"Z: "));
        this.setupEditBoxes((value, widget) -> {
            char axis = widget == boxX ? (char)'x' : (widget == boxY ? (char)'y' : (char)'z');
            updater.accept(Character.valueOf(axis), (Integer)value);
        }, boxX, boxY, boxZ);
        if (this.animation != null && this.getCurrentFrame() != null) {
            StatuePartTable part = currentFrameSupplier.get();
            this.updateEditBoxes((int)part.getXRot(), (int)part.getYRot(), (int)part.getZRot(), boxX, boxY, boxZ);
        }
        IconButton button = new IconButton(x + 2, yOffset + 2, (ScreenElement)icon);
        button.withCallback(() -> {
            Rotations rot = (Rotations)defaultPoseSupplier.get();
            this.updateRotation((Function)rotationSetter.apply(rot));
            boxX.setValue("" + (int)rot.getX());
            boxY.setValue("" + (int)rot.getY());
            boxZ.setValue("" + (int)rot.getZ());
        });
        button.getToolTip().addAll(this.createTooltipFor(tooltipPart));
        buttons.add(button);
        collector.add(boxX);
        collector.add(boxY);
        collector.add(boxZ);
    }

    private void changeFrame(int newFrame, boolean fromSelector) {
        this.currentFrame = newFrame;
        if (!fromSelector) {
            this.frameSelector.setValueNoUpdate("" + newFrame);
        }
        this.updateBoxesFromFrame(newFrame);
    }

    private void updateBoxesFromFrame(int currentFrame) {
        StatueAnimationFrame frame = this.animation.getPreciseFrame(currentFrame);
        if (frame != null) {
            List<StatuePartTable> rotations = List.of(frame.getGlobal(), frame.getHead(), frame.getLeftArm(), frame.getRightArm(), frame.getLeftLeg(), frame.getRightLeg());
            int widgetIndex = 0;
            for (StatuePartTable rot : rotations) {
                this.editWidgets.get(widgetIndex++).setValue("" + (int)rot.getXRot());
                this.editWidgets.get(widgetIndex++).setValue("" + (int)rot.getYRot());
                this.editWidgets.get(widgetIndex++).setValue("" + (int)rot.getZRot());
            }
        }
    }

    private List<Component> createTooltipFor(PlayerModelPart part) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)CreateQOLLang.translateDirect("statue.animation.copy_from", CreateQOLLang.translateDirect("statue.rotation." + part.name().toLowerCase(), new Object[0])));
        return components;
    }

    private void setupEditBoxes(BiConsumer<Integer, ScrollableEditBox> onChanged, ScrollableEditBox ... inputs) {
        for (ScrollableEditBox widget : inputs) {
            widget.setMaxLength(4);
            widget.setBordered(false);
            widget.setTextColor(0xFFFFFF);
            widget.setFocused(false);
            widget.mouseClicked(0.0, 0.0, 0);
            widget.setResponder(s -> {
                if (!s.isEmpty()) {
                    try {
                        int i = Integer.parseInt(s);
                        onChanged.accept(i, widget);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            widget.setFilter(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    int i = Integer.parseInt(s);
                    return i >= -180 && i < 180;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
    }

    private void updateEditBoxes(int value1, int value2, int value3, EditBox ... inputs) {
        if (inputs.length != 3) {
            return;
        }
        inputs[0].setValue("" + value1);
        inputs[1].setValue("" + value2);
        inputs[2].setValue("" + value3);
    }

    @Override
    public void onQuit() {
        super.onQuit();
        this.getExampleStatue().setAnimation(this.animation);
    }

    private StatueAnimationFrame getCurrentFrame() {
        if (this.animation == null) {
            return null;
        }
        return this.animation.getPreciseFrame(this.currentFrame);
    }

    private void updateRotation(Function<StatueAnimationFrame, StatueAnimationFrame> function) {
        if (this.animation == null) {
            return;
        }
        if (!this.animation.doesFrameExist(this.currentFrame)) {
            return;
        }
        StatueAnimationFrame frame = this.getCurrentFrame();
        frame = function.apply(frame);
        this.animation.updateFrame(this.currentFrame, frame);
    }

    private void updateGlobal(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getGlobal();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withGlobalRotation(x, y, z);
        });
    }

    private void updateHead(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getHead();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withHeadRotation(x, y, z);
        });
    }

    private void updateLeftArm(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getLeftArm();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withLeftArmRotation(x, y, z);
        });
    }

    private void updateRightArm(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getRightArm();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withRightArmRotation(x, y, z);
        });
    }

    private void updateLeftLeg(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getLeftLeg();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withLeftLegRotation(x, y, z);
        });
    }

    private void updateRightLeg(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getRightLeg();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withRightLegRotation(x, y, z);
        });
    }

    private void createButtonCallback() {
        if (this.animation == null) {
            this.animation = new StatueAnimation();
        } else if (this.getCurrentFrame() == null) {
            this.animation.addFrame(new StatueAnimationFrame(this.currentFrame));
        } else {
            throw new RuntimeException(new IllegalAccessException("Create Button shouldn't be accessible when animation and frame aren't null, animation: " + String.valueOf(this.animation) + ", frame: " + String.valueOf(this.getCurrentFrame())));
        }
    }
}

