/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import fr.iglee42.createqualityoflife.blocks.StockManagerBlock;
import fr.iglee42.createqualityoflife.menus.ChooseLogisticNetworkMenu;
import fr.iglee42.createqualityoflife.menus.StockManagerMenu;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class StockManagerBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation {
    public LogisticallyLinkedBehaviour behaviour;
    public LerpedFloat headAnimation = LerpedFloat.linear();
    public LerpedFloat headAngle = LerpedFloat.angular();
    public UUID placedBy;

    public StockManagerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)state.getOptionalValue((Property)StockManagerBlock.FACING).orElse(Direction.SOUTH)) + 180.0f) % 360.0f));
        this.placedBy = null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.behaviour = new LogisticallyLinkedBehaviour((SmartBlockEntity)this, true);
        behaviours.add((BlockEntityBehaviour)this.behaviour);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean shouldTickAnimation() {
        return !VisualizationManager.supportsVisualization((LevelAccessor)this.level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAnimation() {
        float target = 0.0f;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && !player.isInvisible()) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.getX();
                z = player.getZ();
            }
            double dx = x - ((double)this.getBlockPos().getX() + 0.5);
            double dz = z - ((double)this.getBlockPos().getZ() + 0.5);
            target = AngleHelper.deg((double)(-Mth.atan2((double)dz, (double)dx))) - 90.0f;
        }
        target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
        this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
        this.headAngle.tickChaser();
        this.headAnimation.chase(0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            if (this.shouldTickAnimation()) {
                this.tickAnimation();
            }
            return;
        }
    }

    public boolean hasBlazeFromBlock() {
        return this.getBlockState().getOptionalValue((Property)StockManagerBlock.HAS_BLAZE).orElse(false);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.placedBy != null) {
            tag.putUUID("PlacedBy", this.placedBy);
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.placedBy = tag.contains("PlacedBy") ? tag.getUUID("PlacedBy") : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return true;
    }

    public class ChooseNetworkProvider
    implements MenuProvider {
        public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
            return ChooseLogisticNetworkMenu.create(pContainerId, pPlayerInventory, StockManagerBlockEntity.this);
        }

        public Component getDisplayName() {
            return Component.empty();
        }
    }

    public class StockManagerProvider
    implements MenuProvider {
        public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
            return StockManagerMenu.create(pContainerId, pPlayerInventory, StockManagerBlockEntity.this);
        }

        public Component getDisplayName() {
            return Component.empty();
        }
    }
}

