/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife;

import com.mojang.logging.LogUtils;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import fr.iglee42.createqualityoflife.CreateQOLClient;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.blockentitites.BrassTrashCanBlockEntity;
import fr.iglee42.createqualityoflife.blockentitites.ChippedSawBlockEntity;
import fr.iglee42.createqualityoflife.blockentitites.EnderPackagerBlockEntity;
import fr.iglee42.createqualityoflife.blockentitites.InventoryLinkerBlockEntity;
import fr.iglee42.createqualityoflife.blockentitites.TrashCanBlockEntity;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.config.CreateQOLFeaturesConfig;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.items.tools.refinedradiance.RefinedRadianceHoe;
import fr.iglee42.createqualityoflife.items.tools.refinedradiance.RefinedRadiancePickaxe;
import fr.iglee42.createqualityoflife.items.tools.refinedradiance.RefinedRadianceShovel;
import fr.iglee42.createqualityoflife.items.tools.shadowsteel.ShadowSteelAxe;
import fr.iglee42.createqualityoflife.items.tools.shadowsteel.ShadowSteelPickaxe;
import fr.iglee42.createqualityoflife.items.tools.shadowsteel.ShadowSteelShovel;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.registries.QOLBlocks;
import fr.iglee42.createqualityoflife.registries.QOLConditions;
import fr.iglee42.createqualityoflife.registries.QOLCreativeModeTabs;
import fr.iglee42.createqualityoflife.registries.QOLDataComponents;
import fr.iglee42.createqualityoflife.registries.QOLEntityDataSerializers;
import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLMenuTypes;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.registries.QOLRecipeTypes;
import fr.iglee42.createqualityoflife.statue.animation.PublishedAnimationsManager;
import fr.iglee42.createqualityoflife.utils.EnderPackagersNetworkHandler;
import fr.iglee42.createqualityoflife.utils.Features;
import fr.iglee42.createqualityoflife.utils.IHaveTankMixin;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerReloadListener;
import java.io.IOException;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.slf4j.Logger;

@Mod(value="createqol")
public class CreateQOL {
    public static final String MODID = "createqol";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final EnderPackagersNetworkHandler ENDER_PACKAGER_NETWORK_HANDLER = new EnderPackagersNetworkHandler();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createqol").defaultCreativeTab((ResourceKey)null);

    public CreateQOL(IEventBus modEventBus, ModContainer container) throws IOException, IllegalAccessException {
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        CreateQOLFeaturesConfig.load();
        REGISTRATE.registerEventListeners(modEventBus);
        QOLBlocks.register();
        QOLBlockEntities.register();
        QOLItems.register();
        QOLCreativeModeTabs.register(modEventBus);
        QOLPackets.register();
        QOLDataComponents.register(modEventBus);
        QOLConditions.CONDITIONS.register(modEventBus);
        QOLRecipeTypes.register(modEventBus);
        QOLEntityDataSerializers.ENTITY_SERIALIZERS.register(modEventBus);
        QOLEntityTypes.ENTITIES.register(modEventBus);
        QOLMenuTypes.register();
        CreateQOLConfigs.register(ModLoadingContext.get(), container);
        RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateQOLClient.onCtorClient(modEventBus, forgeEventBus));
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(ChippedSawBlockEntity::registerCapabilities);
        modEventBus.addListener(InventoryLinkerBlockEntity::registerCapabilities);
        modEventBus.addListener(TrashCanBlockEntity::registerCapabilities);
        modEventBus.addListener(BrassTrashCanBlockEntity::registerCapabilities);
        modEventBus.addListener(EnderPackagerBlockEntity::registerCapabilities);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(QOLEntityTypes::registerEntityAttributes);
        forgeEventBus.addListener(this::removeFallDamage);
        forgeEventBus.addListener(this::registerReloadListener);
        forgeEventBus.addListener(this::playerJoin);
        forgeEventBus.addListener(this::onWorldTick);
        forgeEventBus.addListener(this::itemTooltips);
        this.registerToolsEvents(modEventBus, forgeEventBus);
    }

    private void registerToolsEvents(IEventBus modEventBus, IEventBus forgeEventBus) {
        forgeEventBus.addListener(QOLConfigurableItem::modifyAttributes);
        forgeEventBus.addListener(BlockEvent.BreakEvent.class, RefinedRadiancePickaxe::mineBlock);
        forgeEventBus.addListener(BlockEvent.BreakEvent.class, ShadowSteelPickaxe::mineBlock);
        forgeEventBus.addListener(BlockEvent.BreakEvent.class, ShadowSteelAxe::mineBlock);
        forgeEventBus.addListener(BlockEvent.BreakEvent.class, RefinedRadianceHoe::mineBlock);
        forgeEventBus.addListener(BlockEvent.BreakEvent.class, ShadowSteelShovel::mineBlock);
        forgeEventBus.addListener(RefinedRadianceShovel::blockDrops);
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)AllBlockEntityTypes.HEATER.get(), (be, context) -> {
            if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
                return null;
            }
            if (!(be instanceof IHaveTankMixin)) {
                return null;
            }
            IHaveTankMixin tank = (IHaveTankMixin)be;
            return tank.createQOL$tank();
        });
    }

    private void registerReloadListener(AddReloadListenerEvent event) {
        if (!CreateQOL.isActivate(Features.LIQUID_BLAZE_BURNER)) {
            return;
        }
        event.addListener((PreparableReloadListener)LiquidBlazeBurnerReloadListener.INSTANCE);
    }

    public static boolean isChippedLoaded() {
        return ModList.get().isLoaded("chipped");
    }

    public static boolean isActivate(Features feature) {
        return feature.getConfig();
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    public void removeFallDamage(LivingIncomingDamageEvent event) {
        if (!event.getSource().equals(event.getEntity().level().damageSources().fall())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.getItemBySlot(EquipmentSlot.CHEST).is(QOLItems.SHADOW_RADIANCE_CHESTPLATE)) {
            ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
            if (BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
                return;
            }
            if (ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ShadowRadianceChestplate.hasPropeller(stack) || ((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()).booleanValue()) {
                event.setCanceled(true);
            }
        }
        if (player.getItemBySlot(EquipmentSlot.CHEST).is(QOLItems.SHADOW_STEEL_CHESTPLATE)) {
            if (BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
                return;
            }
            if (!((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }

    private void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player p = event.getEntity();
        if (p.level().isClientSide) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (!p.hasPermissions(1)) {
            return;
        }
        if (CreateQOL.isActivate(Features.STOCK_MANAGER) && ((Boolean)CreateQOLConfigs.server().experimentalWarning.get()).booleanValue()) {
            player.displayClientMessage((Component)CreateQOLLang.translateDirect("client_message.header", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)CreateQOLLang.translateDirect("client_message.warning", new Object[0]).withStyle(ChatFormatting.WHITE)), false);
        }
    }

    public void onWorldTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        PublishedAnimationsManager manager = PublishedAnimationsManager.get(event.getLevel());
        manager.tick();
    }

    public void itemTooltips(ItemTooltipEvent event) {
        if (!event.getItemStack().is(Items.FIREWORK_ROCKET)) {
            return;
        }
        if (CreateQOL.isActivate(Features.SHADOW_RADIANCE) && ((Boolean)CreateQOLConfigs.server().equipments.armors.elytraBoostAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().equipments.armors.useFireworksForBoost.get()).booleanValue()) {
            event.getToolTip().add(2, CreateQOLLang.translateDirect("armor.ability.use_fireworks", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

