/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.flywheel;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.flywheel.PoweredFlywheelBlock;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class PoweredFlywheelBE
extends GeneratingKineticBlockEntity {
    public Direction engineDirection;
    public BlockPos enginePos;
    public float engineEfficiency;
    public int movementDirection = 1;
    public int initialTicks = 3;
    public Block capacityKey;
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;

    public PoweredFlywheelBE(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(2.0);
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.initialTicks > 0) {
            --this.initialTicks;
        }
        BlockState state = this.getBlockState();
        if (this.level != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = state.getBlock();
            if (level instanceof PoweredFlywheelBlock) {
                PoweredFlywheelBlock block = (PoweredFlywheelBlock)level;
                block.simpleTick(state, serverLevel, this.getBlockPos(), (Direction)state.getValue((Property)PoweredFlywheelBlock.FACING), (Direction.Axis)state.getValue((Property)PoweredFlywheelBlock.AXIS));
            }
        }
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
    }

    public void update(Direction sourceDirection, BlockPos sourcePos, int direction, float efficiency) {
        this.enginePos = this.worldPosition.subtract((Vec3i)sourcePos);
        this.engineDirection = sourceDirection;
        float prev = this.engineEfficiency;
        this.engineEfficiency = efficiency;
        int prevDirection = this.movementDirection;
        if (Mth.equal((float)efficiency, (float)prev) && prevDirection == direction) {
            return;
        }
        if (this.level == null) {
            return;
        }
        this.capacityKey = this.level.getBlockState(sourcePos).getBlock();
        this.movementDirection = direction;
        this.updateGeneratedRotation();
    }

    public void remove(BlockPos sourcePos) {
        if (!this.isPoweredBy(sourcePos)) {
            return;
        }
        this.enginePos = null;
        this.engineDirection = null;
        this.engineEfficiency = 0.0f;
        this.movementDirection = 0;
        this.capacityKey = null;
        this.updateGeneratedRotation();
    }

    public boolean canBePoweredBy(BlockPos globalPos) {
        return this.initialTicks == 0 && (this.enginePos == null || this.isPoweredBy(globalPos));
    }

    public boolean isPoweredBy(BlockPos globalPos) {
        BlockPos key = this.worldPosition.subtract((Vec3i)globalPos);
        return key.equals((Object)this.enginePos);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            compound.putInt("Warmup", this.initialTicks);
        }
        if (this.enginePos != null && this.capacityKey != null) {
            compound.put("EnginePos", NbtUtils.writeBlockPos((BlockPos)this.enginePos));
            compound.putFloat("EnginePower", this.engineEfficiency);
            compound.putString("EngineType", RegisteredObjectsHelper.getKeyOrThrow((Block)this.capacityKey).toString());
        }
        if (this.engineDirection != null) {
            NBTHelper.writeEnum((CompoundTag)compound, (String)"EngineDirection", (Enum)this.engineDirection);
        }
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.015625, LerpedFloat.Chaser.EXP);
        }
        this.movementDirection = compound.getInt("Direction");
        this.initialTicks = compound.getInt("Warmup");
        this.enginePos = null;
        this.engineDirection = null;
        this.engineEfficiency = 0.0f;
        if (compound.contains("EnginePos")) {
            this.enginePos = NBTHelper.readBlockPos((CompoundTag)compound, (String)"EnginePos");
            this.engineEfficiency = compound.getFloat("EnginePower");
            this.capacityKey = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)compound.getString("EngineType")));
        }
        if (compound.contains("EngineDirection")) {
            this.engineDirection = (Direction)NBTHelper.readEnum((CompoundTag)compound, (String)"EngineDirection", Direction.class);
        }
    }

    public float getGeneratedSpeed() {
        return this.getCombinedCapacity() > 0.0f ? (float)(this.movementDirection * 8 * this.getSpeedModifier()) : 0.0f;
    }

    private float getCombinedCapacity() {
        return this.capacityKey == null ? 0.0f : this.engineEfficiency * (float)BlockStressValues.getCapacity((Block)this.capacityKey);
    }

    private int getSpeedModifier() {
        return (int)(1.0f + this.engineEfficiency * 4.0f);
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.getCombinedCapacity();
        return capacity;
    }

    public int getRotationAngleOffset(Direction.Axis axis) {
        int combinedCords = axis.choose(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
        return super.getRotationAngleOffset(axis) + (combinedCords % 2 == 0 ? 180 : 0);
    }

    public boolean addToEngineTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

