/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.lopyluna.dndesires.content.recipes.DragonBreathingRecipe;
import dev.lopyluna.dndesires.register.DesiresBlocks;
import dev.lopyluna.dndesires.register.client.DesiresPartialModels;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.dragon.DragonHeadModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DragonBreathingCategory
extends ProcessingViaFanCategory.MultiOutput<DragonBreathingRecipe> {
    private static final ResourceLocation DRAGON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderdragon/dragon.png");
    private float animationTickCount = 0.0f;

    public DragonBreathingCategory(CreateRecipeCategory.Info<DragonBreathingRecipe> info) {
        super(info);
    }

    public void draw(DragonBreathingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.renderWidgets(graphics, recipe, mouseX, mouseY);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        this.translateFan(matrixStack);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-12.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        AnimatedKinetics.defaultBlockElement((PartialModel)DesiresPartialModels.INDUSTRIAL_FAN_INNER).rotateBlock(180.0, 0.0, (double)(AnimatedKinetics.getCurrentAngle() * 16.0f)).scale(24.0).render(graphics);
        AnimatedKinetics.defaultBlockElement((PartialModel)DesiresPartialModels.INDUSTRIAL_FAN_POWER).rotateBlock(180.0, 0.0, (double)AnimatedKinetics.getCurrentAngle()).scale(24.0).render(graphics);
        AnimatedKinetics.defaultBlockElement((BlockState)DesiresBlocks.INDUSTRIAL_FAN.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale(24.0).render(graphics);
        this.renderAttachedBlock(graphics);
        matrixStack.popPose();
    }

    protected void renderAttachedBlock(@NotNull GuiGraphics graphics) {
        BlockState lever = Blocks.LEVER.defaultBlockState();
        lever = (BlockState)lever.setValue((Property)LeverBlock.FACE, (Comparable)AttachFace.WALL);
        lever = (BlockState)lever.setValue((Property)LeverBlock.FACING, (Comparable)Direction.WEST);
        lever = (BlockState)lever.setValue((Property)LeverBlock.POWERED, (Comparable)Boolean.valueOf(true));
        GuiGameElement.of((BlockState)lever).scale(24.0).atLocal(-1.0, 0.0, 0.0).lighting(AnimatedKinetics.DEFAULT_LIGHTING).render(graphics);
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.scale(24.0f, 24.0f, 24.0f);
        pose.translate(0.4, -0.2, 2.5);
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        Minecraft mc = Minecraft.getInstance();
        DragonHeadModel head = new DragonHeadModel(mc.getEntityModels().bakeLayer(ModelLayers.DRAGON_SKULL));
        MultiBufferSource.BufferSource buffer = graphics.bufferSource();
        VertexConsumer vb = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)DRAGON_LOCATION));
        this.animationTickCount += 0.04f;
        head.setupAnim(this.animationTickCount, RotationSegment.convertToDegrees((int)RotationSegment.convertToSegment((Direction)Direction.SOUTH)), 0.0f);
        head.renderToBuffer(pose, vb, 0xF000F0, OverlayTexture.NO_OVERLAY);
        pose.popPose();
        buffer.endBatch();
    }
}

