/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.CachedMethodInfo;
import dev.latvian.mods.rhino.CachedParameters;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Function;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Kit;
import dev.latvian.mods.rhino.MemberBox;
import dev.latvian.mods.rhino.NativeArray;
import dev.latvian.mods.rhino.NativeJavaArray;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.ResolvedOverload;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.ParameterizedTypeInfo;
import dev.latvian.mods.rhino.type.TypeConsolidator;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Array;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class NativeJavaMethod
extends BaseFunction {
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private final String functionName;
    private final transient CopyOnWriteArrayList<ResolvedOverload> overloadCache = new CopyOnWriteArrayList();
    public transient MemberBox[] methods;

    static String scriptSignature(Object[] values) {
        StringBuilder sig = new StringBuilder();
        for (int i = 0; i != values.length; ++i) {
            String s;
            Object value = values[i];
            if (value == null) {
                s = "null";
            } else if (value instanceof Boolean) {
                s = "boolean";
            } else if (value instanceof String) {
                s = "string";
            } else if (value instanceof Number) {
                s = "number";
            } else if (value instanceof Scriptable) {
                if (value instanceof Undefined) {
                    s = "undefined";
                } else if (value instanceof Wrapper) {
                    Object wrapped = ((Wrapper)value).unwrap();
                    s = wrapped.getClass().getName();
                } else {
                    s = value instanceof Function ? "function" : "object";
                }
            } else {
                s = JavaMembers.javaSignature(value.getClass());
            }
            if (i != 0) {
                sig.append(',');
            }
            sig.append(s);
        }
        return sig.toString();
    }

    static int findFunction(Context cx, MemberBox[] methodsOrCtors, Object[] args) {
        if (methodsOrCtors.length == 0) {
            return -1;
        }
        if (methodsOrCtors.length == 1) {
            MemberBox member = methodsOrCtors[0];
            CachedParameters pars = member.parameters();
            int alength = member.parameters().count();
            if (pars.isVarArg() ? --alength > args.length : alength != args.length) {
                return -1;
            }
            for (int j = 0; j != alength; ++j) {
                if (cx.canConvert(args[j], pars.typeInfos().get(j))) continue;
                return -1;
            }
            return 0;
        }
        int firstBestFit = -1;
        int[] extraBestFits = null;
        int extraBestFitsCount = 0;
        block1: for (int i = 0; i < methodsOrCtors.length; ++i) {
            MemberBox member = methodsOrCtors[i];
            CachedParameters pars = member.parameters();
            int alength = pars.count();
            if (pars.isVarArg() ? --alength > args.length : alength != args.length) continue;
            for (int j = 0; j < alength; ++j) {
                if (!cx.canConvert(args[j], pars.typeInfos().get(j))) continue block1;
            }
            if (firstBestFit < 0) {
                firstBestFit = i;
                continue;
            }
            int betterCount = 0;
            int worseCount = 0;
            for (int j = -1; j != extraBestFitsCount; ++j) {
                int bestFitIndex = j == -1 ? firstBestFit : extraBestFits[j];
                MemberBox bestFit = methodsOrCtors[bestFitIndex];
                CachedParameters bestFitPars = bestFit.parameters();
                int preference = NativeJavaMethod.preferSignature(cx, args, pars.typeInfos(), pars.isVarArg(), bestFitPars.typeInfos(), bestFitPars.isVarArg());
                if (preference == 3) break;
                if (preference == 1) {
                    ++betterCount;
                    continue;
                }
                if (preference == 2) {
                    ++worseCount;
                    continue;
                }
                if (preference != 0) {
                    Kit.codeBug();
                }
                if (!bestFit.isStatic() || !bestFit.executableInfo.getDeclaringClass().type.isAssignableFrom(member.executableInfo.getDeclaringClass().type)) continue block1;
                if (j == -1) {
                    firstBestFit = i;
                    continue block1;
                }
                extraBestFits[j] = i;
                continue block1;
            }
            if (betterCount == 1 + extraBestFitsCount) {
                firstBestFit = i;
                extraBestFitsCount = 0;
                continue;
            }
            if (worseCount == 1 + extraBestFitsCount) continue;
            if (extraBestFits == null) {
                extraBestFits = new int[methodsOrCtors.length - 1];
            }
            extraBestFits[extraBestFitsCount] = i;
            ++extraBestFitsCount;
        }
        if (firstBestFit < 0) {
            return -1;
        }
        if (extraBestFitsCount == 0) {
            return firstBestFit;
        }
        StringBuilder buf = new StringBuilder();
        for (int j = -1; j != extraBestFitsCount; ++j) {
            int bestFitIndex = j == -1 ? firstBestFit : extraBestFits[j];
            buf.append("\n    ");
            buf.append(methodsOrCtors[bestFitIndex].toJavaDeclaration());
        }
        MemberBox firstFitMember = methodsOrCtors[firstBestFit];
        String memberName = firstFitMember.getName();
        String memberClass = firstFitMember.executableInfo.getDeclaringClass().type.getName();
        if (methodsOrCtors[0].isCtor()) {
            throw Context.reportRuntimeError3("msg.constructor.ambiguous", memberName, NativeJavaMethod.scriptSignature(args), buf.toString(), cx);
        }
        throw Context.reportRuntimeError4("msg.method.ambiguous", memberClass, memberName, NativeJavaMethod.scriptSignature(args), buf.toString(), cx);
    }

    private static int preferSignature(Context cx, Object[] args, List<TypeInfo> sig1, boolean vararg1, List<TypeInfo> sig2, boolean vararg2) {
        int totalPreference = 0;
        for (int j = 0; j < args.length; ++j) {
            int rank2;
            TypeInfo type2;
            TypeInfo type1 = vararg1 && j >= sig1.size() ? sig1.getLast() : sig1.get(j);
            TypeInfo typeInfo = type2 = vararg2 && j >= sig2.size() ? sig2.getLast() : sig2.get(j);
            if (type1.equals(type2)) continue;
            Object arg = args[j];
            int rank1 = cx.getConversionWeight(arg, type1);
            int preference = rank1 < (rank2 = cx.getConversionWeight(arg, type2)) ? 1 : (rank1 > rank2 ? 2 : (rank1 == 0 ? (type1.asClass().isAssignableFrom(type2.asClass()) ? 2 : (type2.asClass().isAssignableFrom(type1.asClass()) ? 1 : 3)) : 3));
            if ((totalPreference |= preference) == 3) break;
        }
        return totalPreference;
    }

    NativeJavaMethod(MemberBox[] methods) {
        this.functionName = methods[0].getName();
        this.methods = methods;
    }

    NativeJavaMethod(MemberBox[] methods, String name) {
        this.functionName = name;
        this.methods = methods;
    }

    NativeJavaMethod(MemberBox method, String name) {
        this.functionName = name;
        this.methods = new MemberBox[]{method};
    }

    public NativeJavaMethod(CachedMethodInfo method, String name) {
        this(new MemberBox(method), name);
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int N = this.methods.length;
        for (int i = 0; i != N; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            if (this.methods[i].isMethod()) {
                sb.append(JavaMembers.javaSignature(this.methods[i].getReturnType().asClass()));
                sb.append(' ');
                sb.append(this.methods[i].getName());
            } else {
                sb.append(this.methods[i].getName());
            }
            sb.append(JavaMembers.liveConnectSignature(this.methods[i].parameters().types()));
        }
        return sb.toString();
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object wrapped;
        Object javaObject;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int index = this.findCachedFunction(cx, args);
        if (index < 0) {
            Class<?> c = this.methods[0].executableInfo.getDeclaringClass().getClass();
            String sig = c.getName() + "." + this.getFunctionName() + "(" + NativeJavaMethod.scriptSignature(args) + ")";
            throw Context.reportRuntimeError1("msg.java.no_such_method", sig, cx);
        }
        MemberBox meth = this.methods[index];
        CachedParameters pars = meth.parameters();
        List<TypeInfo> argTypes = pars.typeInfos();
        if (thisObj instanceof NativeJavaObject) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)thisObj;
            TypeInfo typeInfo = nativeJavaObject.typeInfo;
            if (typeInfo instanceof ParameterizedTypeInfo) {
                ParameterizedTypeInfo ignored = (ParameterizedTypeInfo)typeInfo;
                argTypes = TypeConsolidator.consolidateAll(argTypes, nativeJavaObject.getTypeMapping());
            }
        }
        if (pars.isVarArg()) {
            Object varArgs;
            Object[] newArgs = new Object[argTypes.size()];
            for (int i = 0; i < argTypes.size() - 1; ++i) {
                newArgs[i] = cx.jsToJava(args[i], argTypes.get(i));
            }
            if (args.length == argTypes.size() && (args[args.length - 1] == null || args[args.length - 1] instanceof NativeArray || args[args.length - 1] instanceof NativeJavaArray)) {
                varArgs = cx.jsToJava(args[args.length - 1], argTypes.getLast());
            } else {
                TypeInfo componentType = argTypes.getLast().componentType();
                varArgs = Array.newInstance(componentType.asClass(), args.length - argTypes.size() + 1);
                int len = Array.getLength(varArgs);
                for (int i = 0; i < len; ++i) {
                    Object value = cx.jsToJava(args[argTypes.size() - 1 + i], componentType);
                    Array.set(varArgs, i, value);
                }
            }
            newArgs[argTypes.size() - 1] = varArgs;
            args = newArgs;
        } else {
            Object[] origArgs = args;
            for (int i = 0; i < args.length; ++i) {
                Object arg;
                Object coerced = arg = args[i];
                if ((coerced = cx.jsToJava(coerced, argTypes.get(i))) == arg) continue;
                if (origArgs == args) {
                    args = (Object[])args.clone();
                }
                args[i] = coerced;
            }
        }
        if (meth.isStatic()) {
            javaObject = null;
        } else {
            Scriptable o = thisObj;
            Class<?> c = meth.executableInfo.getDeclaringClass().type;
            while (true) {
                if (o == null) {
                    throw Context.reportRuntimeError3("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(cx, thisObj), c.getName(), cx);
                }
                if (o instanceof Wrapper && c.isInstance(javaObject = ((Wrapper)((Object)o)).unwrap())) break;
                o = o.getPrototype(cx);
            }
        }
        Object retval = meth.invoke(javaObject, args, cx, scope);
        TypeInfo returnType = meth.getReturnType();
        if (thisObj instanceof NativeJavaObject) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)thisObj;
            returnType = returnType.consolidate(nativeJavaObject.getTypeMapping());
        }
        if ((wrapped = cx.wrap(scope, retval, returnType)) == null && returnType.isVoid()) {
            wrapped = Undefined.INSTANCE;
        }
        return wrapped;
    }

    int findCachedFunction(Context cx, Object[] args) {
        if (this.methods.length > 1) {
            for (ResolvedOverload ovl : this.overloadCache) {
                if (!ovl.matches(args)) continue;
                return ovl.index;
            }
            int index = NativeJavaMethod.findFunction(cx, this.methods, args);
            if (this.overloadCache.size() < this.methods.length * 2) {
                ResolvedOverload ovl;
                ovl = new ResolvedOverload(args, index);
                this.overloadCache.addIfAbsent(ovl);
            }
            return index;
        }
        return NativeJavaMethod.findFunction(cx, this.methods, args);
    }
}

