/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.Callable;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.VMBridge;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class InterfaceAdapter {
    private final Object proxyHelper;

    static Object create(Context cx, Class<?> cl, ScriptableObject object) {
        if (!cl.isInterface()) {
            throw new IllegalArgumentException();
        }
        Scriptable topScope = cx.getTopCallOrThrow();
        InterfaceAdapter adapter = (InterfaceAdapter)cx.getInterfaceAdapter(cl);
        if (adapter == null) {
            Method[] methods = cl.getMethods();
            if (object instanceof Callable) {
                int length = methods.length;
                if (length == 0) {
                    throw Context.reportRuntimeError1("msg.no.empty.interface.conversion", cl.getName(), cx);
                }
                if (length > 1) {
                    String methodName = null;
                    for (Method method : methods) {
                        if (!InterfaceAdapter.isFunctionalMethodCandidate(method)) continue;
                        if (methodName == null) {
                            methodName = method.getName();
                            continue;
                        }
                        if (methodName.equals(method.getName())) continue;
                        throw Context.reportRuntimeError1("msg.no.function.interface.conversion", cl.getName(), cx);
                    }
                }
            }
            adapter = new InterfaceAdapter(cx, cl);
            cx.cacheInterfaceAdapter(cl, adapter);
        }
        return VMBridge.newInterfaceProxy(adapter.proxyHelper, adapter, object, topScope, cx);
    }

    private static boolean isFunctionalMethodCandidate(Method method) {
        if (method.getName().equals("equals") || method.getName().equals("hashCode") || method.getName().equals("toString")) {
            return false;
        }
        return Modifier.isAbstract(method.getModifiers());
    }

    private InterfaceAdapter(Context cx, Class<?> cl) {
        this.proxyHelper = VMBridge.getInterfaceProxyHelper(cx, new Class[]{cl});
    }

    public Object invoke(Context cx, Object target, Scriptable topScope, Object thisObject, Method method, Object[] args) {
        Callable function;
        if (target instanceof Callable) {
            function = (Callable)target;
        } else {
            Scriptable s = (Scriptable)target;
            String methodName = method.getName();
            Object value = ScriptableObject.getProperty(s, methodName, cx);
            if (value == Scriptable.NOT_FOUND) {
                Context.reportWarning(ScriptRuntime.getMessage1("msg.undefined.function.interface", methodName), cx);
                Class<?> resultType = method.getReturnType();
                if (resultType == Void.TYPE) {
                    return null;
                }
                return cx.jsToJava(null, TypeInfo.safeOf(method::getGenericReturnType));
            }
            if (!(value instanceof Callable)) {
                throw Context.reportRuntimeError1("msg.not.function.interface", methodName, cx);
            }
            function = (Callable)value;
        }
        if (args == null || args.length == 0) {
            args = ScriptRuntime.EMPTY_OBJECTS;
        } else {
            int N = args.length;
            for (int i = 0; i != N; ++i) {
                Object arg = args[i];
                if (arg instanceof String || arg instanceof Number || arg instanceof Boolean) continue;
                args[i] = cx.wrap(topScope, arg);
            }
        }
        Scriptable thisObj = cx.wrapAsJavaObject(topScope, thisObject, TypeInfo.NONE);
        Object result = cx.callSync(function, topScope, thisObj, args);
        Type javaResultType = Void.TYPE;
        try {
            javaResultType = method.getGenericReturnType();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        result = javaResultType == Void.TYPE ? null : cx.jsToJava(result, TypeInfo.of(javaResultType));
        return result;
    }
}

