/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.betterstrongholds.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import com.yungnickyoung.minecraft.yungsapi.world.structure.processor.ISafeWorldModifier;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class LegProcessor
extends StructureProcessor
implements ISafeWorldModifier {
    public static final LegProcessor INSTANCE = new LegProcessor();
    public static final MapCodec<LegProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    private final BlockStateRandomizer stoneBrickSelector = new BlockStateRandomizer(Blocks.STONE_BRICKS.defaultBlockState()).addBlock(Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), 0.3f).addBlock(Blocks.CRACKED_STONE_BRICKS.defaultBlockState(), 0.2f).addBlock(Blocks.INFESTED_STONE_BRICKS.defaultBlockState(), 0.05f);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(Blocks.YELLOW_STAINED_GLASS) || blockInfoGlobal.state().is(Blocks.ORANGE_STAINED_GLASS)) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            RandomSource randomSource = structurePlacementData.getRandom(blockInfoGlobal.pos());
            blockInfoGlobal = blockInfoGlobal.state().is(Blocks.YELLOW_STAINED_GLASS) ? new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), this.stoneBrickSelector.get(randomSource), null) : new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.CYAN_TERRACOTTA.defaultBlockState(), null);
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().mutable().move(Direction.DOWN);
            BlockState currBlockState = levelReader.getBlockState((BlockPos)mutable);
            int yBelow = 1;
            while (mutable.getY() > levelReader.getMinBuildHeight() && mutable.getY() < levelReader.getMaxBuildHeight() && (currBlockState.isAir() || !levelReader.getFluidState((BlockPos)mutable).isEmpty())) {
                levelReader.getChunk((BlockPos)mutable).setBlockState((BlockPos)mutable, this.stoneBrickSelector.get(randomSource), false);
                if (yBelow == 1) {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        tempMutable = mutable.relative(direction).mutable();
                        this.setBlockStateSafe(levelReader, (BlockPos)tempMutable, (BlockState)((BlockState)((BlockState)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.FACING, (Comparable)direction.getOpposite())).setValue((Property)StairBlock.WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.getFluidState((BlockPos)tempMutable).is(FluidTags.WATER))));
                        tempMutable.move(direction);
                        this.setBlockStateSafe(levelReader, (BlockPos)tempMutable, (BlockState)((BlockState)((BlockState)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.FACING, (Comparable)direction)).setValue((Property)StairBlock.WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.getFluidState((BlockPos)tempMutable).is(FluidTags.WATER))));
                        tempMutable.move(direction).move(Direction.UP);
                        Optional aboveBlockState = this.getBlockStateSafe(levelReader, (BlockPos)tempMutable);
                        Block aboveBlock = aboveBlockState.map(BlockBehaviour.BlockStateBase::getBlock).orElse(null);
                        tempMutable.move(direction).move(Direction.DOWN);
                        Optional belowBlockState = this.getBlockStateSafe(levelReader, (BlockPos)tempMutable);
                        Block belowBlock = belowBlockState.map(BlockBehaviour.BlockStateBase::getBlock).orElse(null);
                        if (belowBlock != Blocks.STONE_BRICK_STAIRS && aboveBlock != Blocks.STONE_BRICKS && aboveBlock != Blocks.CRACKED_STONE_BRICKS && aboveBlock != Blocks.MOSSY_STONE_BRICKS && aboveBlock != Blocks.INFESTED_STONE_BRICKS) continue;
                        tempMutable.move(direction.getOpposite());
                        this.setBlockStateSafe(levelReader, (BlockPos)tempMutable, Blocks.STONE_BRICKS.defaultBlockState());
                    }
                } else if (yBelow == 2) {
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        tempMutable = mutable.relative(direction).mutable();
                        this.setBlockStateSafe(levelReader, (BlockPos)tempMutable, (BlockState)((BlockState)((BlockState)Blocks.STONE_BRICK_STAIRS.defaultBlockState().setValue((Property)StairBlock.HALF, (Comparable)Half.TOP)).setValue((Property)StairBlock.FACING, (Comparable)direction.getOpposite())).setValue((Property)StairBlock.WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.getFluidState((BlockPos)tempMutable).is(FluidTags.WATER))));
                        tempMutable.move(direction);
                        this.setBlockStateSafe(levelReader, (BlockPos)tempMutable, (BlockState)((BlockState)Blocks.STONE_BRICK_SLAB.defaultBlockState().setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP)).setValue((Property)SlabBlock.WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.getFluidState((BlockPos)tempMutable).is(FluidTags.WATER))));
                    }
                }
                mutable.move(Direction.DOWN);
                currBlockState = levelReader.getBlockState((BlockPos)mutable);
                ++yBelow;
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.LEG_PROCESSOR;
    }
}

