/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerPermissions;
import dev.ftb.mods.ftbteams.net.OpenMyTeamGUIMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public record OpenGUIMessage() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenGUIMessage> TYPE = new CustomPacketPayload.Type(FTBTeamsAPI.rl("open_gui"));
    private static final OpenGUIMessage INSTANCE = new OpenGUIMessage();
    public static final StreamCodec<FriendlyByteBuf, OpenGUIMessage> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public static void handle(OpenGUIMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenMyTeamGUIMessage(team.getProperties(), PlayerPermissions.forPlayer(player))));
        });
    }

    public static void sendToServer() {
        NetworkManager.sendToServer((CustomPacketPayload)INSTANCE);
    }

    public CustomPacketPayload.Type<OpenGUIMessage> type() {
        return TYPE;
    }
}

