/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.SyncMessageHistoryMessage;
import dev.ftb.mods.ftbteams.net.SyncTeamsMessage;
import dev.ftb.mods.ftbteams.net.ToggleChatResponseMessage;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class TeamManagerImpl
implements TeamManager {
    public static final LevelResource FOLDER_NAME = new LevelResource("ftbteams");
    public static TeamManagerImpl INSTANCE;
    private final MinecraftServer server;
    private UUID id;
    private boolean shouldSave;
    private final Map<UUID, PlayerTeam> knownPlayers;
    private final Map<UUID, AbstractTeam> teamMap;
    private final Set<UUID> chatRedirected;
    Map<String, Team> nameMap;
    private CompoundTag extraData;

    public TeamManagerImpl(MinecraftServer s) {
        this.server = s;
        this.knownPlayers = new LinkedHashMap<UUID, PlayerTeam>();
        this.teamMap = new LinkedHashMap<UUID, AbstractTeam>();
        this.extraData = new CompoundTag();
        this.chatRedirected = new HashSet<UUID>();
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    @Override
    public Map<UUID, ? extends Team> getKnownPlayerTeams() {
        return Collections.unmodifiableMap(this.knownPlayers);
    }

    public Map<UUID, AbstractTeam> getTeamMap() {
        return this.teamMap;
    }

    @Override
    public Collection<Team> getTeams() {
        return Collections.unmodifiableCollection(this.teamMap.values());
    }

    public Map<String, Team> getTeamNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Team>();
            for (AbstractTeam team : this.teamMap.values()) {
                this.nameMap.put(team.getShortName(), team);
            }
        }
        return this.nameMap;
    }

    @Override
    public Optional<Team> getTeamByID(UUID teamId) {
        return Optional.ofNullable((Team)this.teamMap.get(teamId));
    }

    @Override
    public Optional<Team> getTeamByName(String name) {
        return Optional.ofNullable(this.getTeamNameMap().get(name));
    }

    @Override
    public Optional<Team> getPlayerTeamForPlayerID(UUID uuid) {
        return Optional.ofNullable(this.getPersonalTeamForPlayerID(uuid));
    }

    public PlayerTeam getPersonalTeamForPlayerID(UUID uuid) {
        return this.knownPlayers.get(uuid);
    }

    @Override
    public Optional<Team> getTeamForPlayerID(UUID uuid) {
        PlayerTeam t = this.knownPlayers.get(uuid);
        return t == null ? Optional.empty() : Optional.ofNullable(t.getEffectiveTeam());
    }

    @Override
    public Optional<Team> getTeamForPlayer(ServerPlayer player) {
        return this.getTeamForPlayerID(player.getUUID());
    }

    @Override
    public boolean arePlayersInSameTeam(UUID id1, UUID id2) {
        return this.getTeamForPlayerID(id1).map(team1 -> this.getTeamForPlayerID(id2).map(team2 -> team1.getId().equals(team2.getId())).orElse(false)).orElse(false);
    }

    public void load() {
        this.id = null;
        Path directory = this.server.getWorldPath(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        SNBTCompoundTag dataFileTag = SNBT.read((Path)directory.resolve("ftbteams.snbt"));
        if (dataFileTag != null) {
            if (dataFileTag.contains("id")) {
                this.id = UUID.fromString(dataFileTag.getString("id"));
            }
            this.extraData = dataFileTag.getCompound("extra");
            ((Consumer)TeamManagerEvent.LOADED.invoker()).accept(new TeamManagerEvent(this));
            this.chatRedirected.clear();
            dataFileTag.getList("chat_redirected", 8).forEach(tag -> {
                try {
                    this.chatRedirected.add(UUID.fromString(tag.getAsString()));
                }
                catch (IllegalArgumentException e) {
                    FTBTeams.LOGGER.error("invalid uuid {} in 'chat_redirection', ignoring", (Object)tag.getAsString());
                }
            });
        }
        for (TeamType type : TeamType.values()) {
            Path dir = directory.resolve(type.getSerializedName());
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            try (Stream<Path> s = Files.list(dir);){
                s.filter(path -> path.getFileName().toString().endsWith(".snbt")).forEach(file -> {
                    SNBTCompoundTag nbt = SNBT.read((Path)file);
                    if (nbt != null) {
                        AbstractTeam team = type.createTeam(this, UUID.fromString(nbt.getString("id")));
                        this.teamMap.put(team.id, team);
                        team.deserializeNBT((CompoundTag)nbt, (HolderLookup.Provider)this.server.registryAccess());
                    }
                });
            }
            catch (Exception ex) {
                FTBTeams.LOGGER.error("can't list directory {}: {}", (Object)dir, (Object)ex.getMessage());
            }
        }
        for (AbstractTeam team : this.teamMap.values()) {
            if (!(team instanceof PlayerTeam)) continue;
            this.knownPlayers.put(team.id, (PlayerTeam)team);
        }
        for (AbstractTeam team : this.teamMap.values()) {
            if (!(team instanceof PartyTeam)) continue;
            for (UUID member : team.getMembers()) {
                PlayerTeam t = this.knownPlayers.get(member);
                if (t == null) continue;
                t.setEffectiveTeam(team);
            }
        }
        FTBTeams.LOGGER.info("loaded team data: {} known players, {} teams total", (Object)this.knownPlayers.size(), (Object)this.teamMap.size());
    }

    @Override
    public void markDirty() {
        this.shouldSave = true;
        this.nameMap = null;
    }

    public void saveNow() {
        Path directory = this.server.getWorldPath(FOLDER_NAME);
        if (!Files.exists(directory, new LinkOption[0])) {
            this.tryCreateDir(directory);
            for (TeamType type : TeamType.values()) {
                this.tryCreateDir(directory.resolve(type.getSerializedName()));
            }
        }
        if (this.shouldSave) {
            ((Consumer)TeamManagerEvent.SAVED.invoker()).accept(new TeamManagerEvent(this));
            SNBT.write((Path)directory.resolve("ftbteams.snbt"), (CompoundTag)this.serializeNBT());
            this.shouldSave = false;
        }
        for (AbstractTeam team : this.teamMap.values()) {
            team.saveIfNeeded(directory, (HolderLookup.Provider)this.server.registryAccess());
        }
    }

    private void tryCreateDir(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Exception ex) {
            FTBTeams.LOGGER.error("can't create directory {}: {} {}", (Object)path, (Object)ex.getClass().getName(), (Object)ex.getMessage());
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.putString("id", this.getId().toString());
        nbt.put("extra", (Tag)this.extraData);
        nbt.put("chat_redirected", (Tag)Util.make((Object)new ListTag(), l -> this.chatRedirected.forEach(id -> l.add((Object)StringTag.valueOf((String)id.toString())))));
        return nbt;
    }

    private ServerTeam createServerTeam(UUID playerId, ServerPlayer player, String name) {
        ServerTeam team = new ServerTeam(this, UUID.randomUUID());
        this.teamMap.put(team.id, team);
        team.setProperty(TeamProperties.DISPLAY_NAME, name.isEmpty() ? team.id.toString().substring(0, 8) : name);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.onCreated(player, playerId);
        return team;
    }

    private PartyTeam createPartyTeamInternal(UUID playerId, @Nullable ServerPlayer player, String name) {
        PartyTeam team = new PartyTeam(this, UUID.randomUUID());
        team.owner = playerId;
        this.teamMap.put(team.id, team);
        team.setProperty(TeamProperties.DISPLAY_NAME, name.isEmpty() ? FTBTUtils.getDefaultPartyName(this.server, playerId, player) : name);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.onCreated(player, playerId);
        return team;
    }

    private PlayerTeam createPlayerTeam(UUID playerId, String playerName) {
        PlayerTeam team = new PlayerTeam(this, playerId);
        team.setPlayerName(playerName);
        team.setProperty(TeamProperties.DISPLAY_NAME, playerName);
        team.setProperty(TeamProperties.COLOR, FTBTUtils.randomColor());
        team.addMember(playerId, TeamRank.OWNER);
        return team;
    }

    public void playerLoggedIn(@Nullable ServerPlayer player, UUID id, String name) {
        PlayerTeam team = this.knownPlayers.get(id);
        boolean syncToAll = false;
        FTBTeams.LOGGER.debug("player {} logged in, player team = {}", (Object)id, (Object)team);
        if (team == null) {
            FTBTeams.LOGGER.debug("creating new player team for player {}", (Object)id);
            team = this.createPlayerTeam(id, name);
            this.teamMap.put(id, team);
            this.knownPlayers.put(id, team);
            team.onCreated(player, id);
            syncToAll = true;
            team.onPlayerChangeTeam(null, id, player, false);
            FTBTeams.LOGGER.debug("  - team created");
        } else if (!team.getPlayerName().equals(name)) {
            FTBTeams.LOGGER.debug("updating player name: {} -> {}", (Object)team.getPlayerName(), (Object)name);
            team.setPlayerName(name);
            team.markDirty();
            this.markDirty();
            syncToAll = true;
        }
        FTBTeams.LOGGER.debug("syncing player team data, all = {}", (Object)syncToAll);
        if (player != null) {
            this.syncAllToPlayer(player, team.getEffectiveTeam());
        }
        if (syncToAll) {
            this.syncToAll(team.getEffectiveTeam());
        }
        FTBTeams.LOGGER.debug("updating team presence");
        team.setOnline(true);
        team.updatePresence();
        if (player != null) {
            FTBTeams.LOGGER.debug("sending team login event for {}...", (Object)player.getUUID());
            ((Consumer)TeamEvent.PLAYER_LOGGED_IN.invoker()).accept(new PlayerLoggedInAfterTeamEvent(team.getEffectiveTeam(), player));
            FTBTeams.LOGGER.debug("team login event for {} sent", (Object)player.getUUID());
        }
    }

    public void playerLoggedOut(ServerPlayer player) {
        PlayerTeam team = this.knownPlayers.get(player.getUUID());
        if (team != null) {
            team.setOnline(false);
            team.updatePresence();
        }
    }

    public void syncAllToPlayer(ServerPlayer player, AbstractTeam selfTeam) {
        ClientTeamManagerImpl manager = ClientTeamManagerImpl.forSyncing(this, this.teamMap.values());
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTeamsMessage(manager.setSelfTeamId(selfTeam.id), selfTeam.getTeamId(), true));
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncMessageHistoryMessage.forTeam(selfTeam));
        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ToggleChatResponseMessage(this.isChatRedirected(player)));
        this.server.getPlayerList().sendPlayerPermissionLevel(player);
    }

    public void syncToAll(Team ... teams) {
        if (teams.length == 0) {
            return;
        }
        ClientTeamManagerImpl manager = ClientTeamManagerImpl.forSyncing(this, Arrays.stream(teams).toList());
        for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
            this.getTeamForPlayer(player).ifPresent(selfTeam -> {
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTeamsMessage(manager.setSelfTeamId(selfTeam.getTeamId()), selfTeam.getTeamId(), false));
                if (teams.length > 1) {
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)SyncMessageHistoryMessage.forTeam(selfTeam));
                }
            });
        }
    }

    @Override
    public Team createPartyTeam(ServerPlayer player, String name, @Nullable String description, @Nullable Color4I color) throws CommandSyntaxException {
        Pair<Integer, PartyTeam> res = this.createParty(player.getUUID(), player, name, description, color);
        return (Team)res.getRight();
    }

    @Override
    public void setChatRedirected(ServerPlayer player, boolean redirect) {
        if (redirect && this.chatRedirected.add(player.getUUID()) || !redirect && this.chatRedirected.remove(player.getUUID())) {
            NetworkHelper.sendTo((ServerPlayer)player, (CustomPacketPayload)new ToggleChatResponseMessage(redirect));
            this.shouldSave = true;
        }
    }

    @Override
    public boolean isChatRedirected(ServerPlayer player) {
        return this.chatRedirected.contains(player.getUUID());
    }

    public Pair<Integer, PartyTeam> createParty(ServerPlayer player, String name) throws CommandSyntaxException {
        return this.createParty(player.getUUID(), player, name, null, null);
    }

    public Pair<Integer, PartyTeam> createParty(UUID playerId, @Nullable ServerPlayer player, String name, @Nullable String description, @Nullable Color4I color) throws CommandSyntaxException {
        if (player != null && !FTBTUtils.canPlayerUseCommand(player, "ftbteams.party.create")) {
            throw TeamArgument.NO_PERMISSION.create();
        }
        Team oldTeam = this.getTeamForPlayerID(playerId).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)playerId));
        if (!(oldTeam instanceof PlayerTeam)) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PlayerTeam playerTeam = (PlayerTeam)oldTeam;
        PartyTeam team = this.createPartyTeamInternal(playerId, player, name);
        if (description != null) {
            team.setProperty(TeamProperties.DESCRIPTION, description);
        }
        if (color != null) {
            team.setProperty(TeamProperties.COLOR, color);
        }
        playerTeam.setEffectiveTeam(team);
        Component playerName = player != null ? player.getName() : Component.literal((String)playerId.toString());
        team.addMember(playerId, TeamRank.OWNER);
        team.sendMessage(Util.NIL_UUID, (Component)Component.translatable((String)"ftbteams.message.joined", (Object[])new Object[]{playerName}).withStyle(ChatFormatting.YELLOW));
        team.markDirty();
        playerTeam.removeMember(playerId);
        playerTeam.markDirty();
        playerTeam.updatePresence();
        this.syncToAll(team, playerTeam);
        team.onPlayerChangeTeam(playerTeam, playerId, player, false);
        return Pair.of((Object)1, (Object)team);
    }

    public Pair<Integer, ServerTeam> createServer(CommandSourceStack source, String name) throws CommandSyntaxException {
        if (name.length() < 3) {
            throw TeamArgument.NAME_TOO_SHORT.create();
        }
        ServerPlayer player = source.getPlayer();
        UUID playerId = player == null ? Util.NIL_UUID : player.getUUID();
        ServerTeam team = this.createServerTeam(playerId, source.getPlayer(), name);
        source.sendSuccess(() -> Component.translatable((String)"ftbteams.message.created_server_team", (Object[])new Object[]{team.getName()}), true);
        this.syncToAll(team);
        return Pair.of((Object)1, (Object)team);
    }

    public Component getPlayerName(@Nullable UUID id) {
        if (id == null || id.equals(Util.NIL_UUID)) {
            return Component.literal((String)"System").withStyle(ChatFormatting.LIGHT_PURPLE);
        }
        PlayerTeam team = this.knownPlayers.get(id);
        return Component.literal((String)(team == null ? "Unknown" : team.getPlayerName())).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public CompoundTag getExtraData() {
        return this.extraData;
    }

    void deleteTeam(AbstractTeam team) {
        this.teamMap.remove(team.getId());
        this.markDirty();
        this.saveNow();
        this.tryDeleteTeamFile(String.valueOf(team.getId()) + ".snbt", team.getType().getSerializedName());
    }

    private void tryDeleteTeamFile(String teamFileName, String subfolderName) {
        Path deletedPath = this.getServer().getWorldPath(FOLDER_NAME).resolve("deleted");
        Path teamFilePath = this.getServer().getWorldPath(FOLDER_NAME).resolve(subfolderName).resolve(teamFileName);
        try {
            Files.createDirectories(deletedPath, new FileAttribute[0]);
            Files.move(teamFilePath, deletedPath.resolve(teamFileName), new CopyOption[0]);
        }
        catch (IOException e) {
            FTBTeams.LOGGER.error("can't move {} to {}: {}", (Object)teamFileName, (Object)deletedPath, (Object)e.getMessage());
            try {
                Files.deleteIfExists(teamFilePath);
            }
            catch (IOException e1) {
                FTBTeams.LOGGER.error("can't delete directory {}: {}", (Object)teamFilePath, (Object)e1.getMessage());
            }
        }
    }
}

