/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config.gui.modules;

import java.util.Objects;
import me.cominixo.betterf3.config.ModConfigFile;
import me.cominixo.betterf3.config.gui.modules.AddModuleScreen;
import me.cominixo.betterf3.config.gui.modules.EditModulesScreen;
import me.cominixo.betterf3.config.gui.modules.ModuleListWidget;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.PositionEnum;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModulesScreen
extends Screen {
    final Screen parent;
    ModuleListWidget modulesListWidget;
    private boolean initialized = false;
    private Button editButton;
    private Button deleteButton;
    public final PositionEnum side;

    public ModulesScreen(Screen parent, PositionEnum side) {
        super((Component)Component.translatable((String)"config.betterf3.title.modules"));
        this.parent = parent;
        this.side = side;
    }

    protected void init() {
        super.init();
        if (this.initialized) {
            this.modulesListWidget.setRectangle(this.width, this.height - 64 - 32, 0, 32);
            this.modulesListWidget.updateModules();
        } else {
            this.initialized = true;
            this.modulesListWidget = new ModuleListWidget(this, this.minecraft, this.width, this.height - 64 - 32, 32, 36);
            if (this.side == PositionEnum.LEFT) {
                this.modulesListWidget.modules(BaseModule.modules);
            } else if (this.side == PositionEnum.RIGHT) {
                this.modulesListWidget.modules(BaseModule.modulesRight);
            }
        }
        this.addRenderableWidget((GuiEventListener)this.modulesListWidget);
        Button editButton = Button.builder((Component)Component.translatable((String)"config.betterf3.modules.edit_button"), button -> {
            Screen screen = EditModulesScreen.configBuilder(Objects.requireNonNull((ModuleListWidget.ModuleEntry)this.modulesListWidget.getSelected()).module, this).build();
            assert (this.minecraft != null);
            this.minecraft.setScreen(screen);
        }).bounds(this.width / 2 - 50, this.height - 50, 100, 20).build();
        this.editButton = (Button)this.addRenderableWidget((GuiEventListener)editButton);
        Button addButton = Button.builder((Component)Component.translatable((String)"config.betterf3.modules.add_button"), button -> {
            assert (this.minecraft != null);
            this.minecraft.setScreen(AddModuleScreen.configBuilder(this).build());
        }).bounds(this.width / 2 + 4 + 50, this.height - 50, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)addButton);
        Button deleteButton = Button.builder((Component)Component.translatable((String)"config.betterf3.modules.delete_button"), button -> this.modulesListWidget.removeModule(this.modulesListWidget.moduleEntries.indexOf((Object)Objects.requireNonNull((ModuleListWidget.ModuleEntry)this.modulesListWidget.getSelected())))).bounds(this.width / 2 - 154, this.height - 50, 100, 20).build();
        this.deleteButton = (Button)this.addRenderableWidget((GuiEventListener)deleteButton);
        Button doneButton = Button.builder((Component)Component.translatable((String)"config.betterf3.modules.done_button"), button -> {
            this.onClose();
            assert (this.minecraft != null);
            this.minecraft.setScreen(this.parent);
        }).bounds(this.width / 2 - 154, this.height - 30 + 4, 308, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        this.updateButtons();
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.modulesListWidget.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void onClose() {
        if (this.side == PositionEnum.LEFT) {
            BaseModule.modules.clear();
            for (ModuleListWidget.ModuleEntry entry : this.modulesListWidget.moduleEntries) {
                BaseModule.modules.add(entry.module);
            }
        } else if (this.side == PositionEnum.RIGHT) {
            BaseModule.modulesRight.clear();
            for (ModuleListWidget.ModuleEntry entry : this.modulesListWidget.moduleEntries) {
                BaseModule.modulesRight.add(entry.module);
            }
        }
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
        ModConfigFile.saveRunnable.run();
    }

    public void select(ModuleListWidget.ModuleEntry entry) {
        this.modulesListWidget.setSelected((AbstractSelectionList.Entry)entry);
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.modulesListWidget.getSelected() != null) {
            this.editButton.active = true;
            this.deleteButton.active = true;
        } else {
            this.editButton.active = false;
            this.deleteButton.active = false;
        }
    }
}

